/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.staticanalysis.csharp.CSharpFileChecker;
import org.openrewrite.staticanalysis.groovy.GroovyFileChecker;
import org.openrewrite.staticanalysis.java.JavaFileChecker;

public class NoEqualityInForCondition
extends Recipe {
    final String displayName = "Use comparison rather than equality checks in for conditions";
    final String description = "Testing for loop termination using an equality operator (`==` and `!=`) is dangerous, because it could set up an infinite loop. Using a relational operator instead makes it harder to accidentally write an infinite loop.";
    final Set<String> tags = Collections.singleton("RSPEC-S888");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        JavaVisitor<ExecutionContext> javaVisitor = new JavaVisitor<ExecutionContext>(){

            public J visitForControl(J.ForLoop.Control control, ExecutionContext ctx) {
                J.Unary update;
                J.Binary condition;
                if (control.getCondition() instanceof J.Binary && this.isNumericalType(condition = (J.Binary)control.getCondition()) && control.getUpdate().size() == 1 && control.getUpdate().get(0) instanceof J.Unary && this.updatedExpressionInConditional((update = (J.Unary)control.getUpdate().get(0)).getExpression(), condition) && condition.getOperator() == J.Binary.Type.NotEqual) {
                    switch (update.getOperator()) {
                        case PreIncrement: 
                        case PostIncrement: {
                            return control.withCondition((Expression)condition.withOperator(J.Binary.Type.LessThan));
                        }
                        case PreDecrement: 
                        case PostDecrement: {
                            return control.withCondition((Expression)condition.withOperator(J.Binary.Type.GreaterThan));
                        }
                    }
                }
                return super.visitForControl(control, (Object)ctx);
            }

            private boolean updatedExpressionInConditional(Expression updatedExpression, J.Binary condition) {
                String simpleName;
                if (updatedExpression instanceof J.Identifier) {
                    simpleName = ((J.Identifier)updatedExpression).getSimpleName();
                } else if (updatedExpression instanceof J.FieldAccess) {
                    simpleName = ((J.FieldAccess)updatedExpression).getSimpleName();
                } else {
                    return false;
                }
                if (condition.getLeft() instanceof J.Identifier) {
                    return simpleName.equals(((J.Identifier)condition.getLeft()).getSimpleName());
                }
                if (condition.getLeft() instanceof J.FieldAccess) {
                    return simpleName.equals(((J.FieldAccess)condition.getLeft()).getSimpleName());
                }
                if (condition.getRight() instanceof J.Identifier) {
                    return simpleName.equals(((J.Identifier)condition.getRight()).getSimpleName());
                }
                if (condition.getRight() instanceof J.FieldAccess) {
                    return simpleName.equals(((J.FieldAccess)condition.getRight()).getSimpleName());
                }
                return false;
            }

            private boolean isNumericalType(J.Binary condition) {
                JavaType type = condition.getRight().getType();
                return type == JavaType.Primitive.Short || type == JavaType.Primitive.Byte || type == JavaType.Primitive.Int || type == JavaType.Primitive.Long;
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new JavaFileChecker(), new GroovyFileChecker(), new CSharpFileChecker()}), (TreeVisitor)javaVisitor);
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

