/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesField;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class NoEmptyCollectionWithRawType
extends Recipe {
    final String displayName = "Use `Collections#emptyList()`, `emptyMap()`, and `emptySet()`";
    final String description = "Replaces `Collections#EMPTY_...` with methods that return generic types.";
    final Set<String> tags = Collections.singleton("RSPEC-S1596");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.Collections", Boolean.valueOf(false)), new UsesField("java.util.Collections", "EMPTY_*")}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){
            final Map<String, String> updateFields = new HashMap<String, String>();
            {
                this.updateFields.put("EMPTY_LIST", "emptyList");
                this.updateFields.put("EMPTY_MAP", "emptyMap");
                this.updateFields.put("EMPTY_SET", "emptySet");
            }

            public J visitImport(J.Import anImport, ExecutionContext ctx) {
                J.Identifier name = anImport.getQualid().getName();
                if (anImport.isStatic() && this.updateFields.containsKey(name.getSimpleName()) && TypeUtils.isOfClassType((JavaType)anImport.getQualid().getTarget().getType(), (String)"java.util.Collections")) {
                    return anImport.withQualid(anImport.getQualid().withName(name.withSimpleName(this.updateFields.get(name.getSimpleName()))));
                }
                return anImport;
            }

            public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                J.Identifier name = fieldAccess.getName();
                JavaType.Variable varType = name.getFieldType();
                if (varType != null && this.updateFields.containsKey(varType.getName()) && TypeUtils.isOfClassType((JavaType)varType.getOwner(), (String)"java.util.Collections")) {
                    return ((J.MethodInvocation)JavaTemplate.builder((String)("java.util.Collections." + this.updateFields.get(varType.getName()) + "()")).contextSensitive().build().apply(this.getCursor(), fieldAccess.getCoordinates().replace(), new Object[0])).withSelect(fieldAccess.getTarget());
                }
                return super.visitFieldAccess(fieldAccess, (Object)ctx);
            }

            public J visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                JavaType.Variable varType = identifier.getFieldType();
                if (varType != null && this.updateFields.containsKey(varType.getName()) && TypeUtils.isOfClassType((JavaType)varType.getOwner(), (String)"java.util.Collections")) {
                    return JavaTemplate.builder((String)(this.updateFields.get(varType.getName()) + "()")).contextSensitive().staticImports(new String[]{"java.util.Collections." + this.updateFields.get(varType.getName())}).build().apply(this.getCursor(), identifier.getCoordinates().replace(), new Object[0]);
                }
                return identifier;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

