/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class NewStringBuilderBufferWithCharArgument
extends Recipe {
    public static final String STRING_BUILDER = "java.lang.StringBuilder";
    public static final String STRING_BUFFER = "java.lang.StringBuffer";
    final String displayName = "Change `StringBuilder` and `StringBuffer` character constructor argument to `String`";
    final String description = "Instantiating a `StringBuilder` or a `StringBuffer` with a `Character` results in the `int` representation of the character being used for the initial size.";
    final Set<String> tags = Collections.singleton("RSPEC-S1317");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor condition = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(STRING_BUILDER, Boolean.valueOf(true)), new UsesType(STRING_BUFFER, Boolean.valueOf(true))});
        return Preconditions.check((TreeVisitor)condition, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = super.visitNewClass(newClass, (Object)ctx);
                if (TypeUtils.isOfClassType((JavaType)nc.getType(), (String)NewStringBuilderBufferWithCharArgument.STRING_BUILDER) || TypeUtils.isOfClassType((JavaType)nc.getType(), (String)NewStringBuilderBufferWithCharArgument.STRING_BUFFER)) {
                    nc.getArguments();
                    if (((Expression)nc.getArguments().get(0)).getType() == JavaType.Primitive.Char) {
                        nc = nc.withArguments(ListUtils.mapFirst((List)nc.getArguments(), arg -> {
                            if (arg instanceof J.Literal) {
                                J.Literal l = (J.Literal)arg;
                                if ((l = l.withType(JavaType.buildType((String)"String"))).getValueSource() != null) {
                                    l = l.withValueSource(l.getValueSource().replace("'", "\""));
                                }
                                return l;
                            }
                            return (Expression)JavaTemplate.builder((String)"String.valueOf(#{any()})").build().apply(new Cursor(this.getCursor(), arg), arg.getCoordinates().replace(), new Object[]{arg});
                        }));
                    }
                }
                return nc;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

