/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.staticanalysis.MultipleVariableDeclarationsVisitor;
import org.openrewrite.staticanalysis.java.JavaFileChecker;

public class MultipleVariableDeclarations
extends Recipe {
    final String displayName = "No multiple variable declarations";
    final String description = "Places each variable declaration in its own statement and on its own line. Using one variable declaration per line encourages commenting and can increase readability.";
    final Set<String> tags = Collections.singleton("RSPEC-S1659");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new JavaFileChecker(), (TreeVisitor)new MultipleVariableDeclarationsVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

