/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.staticanalysis.java.JavaFileChecker;

public class LambdaBlockToExpression
extends Recipe {
    final String displayName = "Simplify lambda blocks to expressions";
    final String description = "Single-line statement lambdas returning a value can be replaced with expression lambdas.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new JavaFileChecker(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext ctx) {
                List statements;
                J.Lambda l = super.visitLambda(lambda, (Object)ctx);
                if (lambda.getBody() instanceof J.Block && (statements = ((J.Block)lambda.getBody()).getStatements()).size() == 1) {
                    Statement statement = (Statement)statements.get(0);
                    Space prefix = statement.getPrefix();
                    if (statement instanceof J.Return) {
                        Expression expression = ((J.Return)statement).getExpression();
                        if (prefix.getComments().isEmpty()) {
                            return l.withBody((J)expression);
                        }
                        if (expression != null) {
                            return l.withBody(expression.withPrefix(prefix));
                        }
                    } else if (statement instanceof J.MethodInvocation) {
                        if (prefix.getComments().isEmpty()) {
                            return l.withBody((J)statement);
                        }
                        return l.withBody(statement.withPrefix(prefix));
                    }
                }
                return l;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (LambdaBlockToExpression.hasLambdaArgument(method) && LambdaBlockToExpression.hasMethodOverloading(method)) {
                    return method;
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    private static boolean hasMethodOverloading(J.MethodInvocation method) {
        JavaType.Method methodType = method.getMethodType();
        return methodType != null && LambdaBlockToExpression.hasMethodOverloading(methodType);
    }

    static boolean hasMethodOverloading(JavaType.Method methodType) {
        String methodName = methodType.getName();
        int numberOfParameters = methodType.getParameterNames().size();
        return Optional.of(methodType).map(JavaType.Method::getDeclaringType).filter(JavaType.Class.class::isInstance).map(JavaType.Class.class::cast).map(JavaType.Class::getMethods).map(methods -> {
            int overloadingCount = 0;
            for (JavaType.Method dm : methods) {
                if (!methodName.equals(dm.getName()) || numberOfParameters != dm.getParameterNames().size() || ++overloadingCount <= 1) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    private static boolean hasLambdaArgument(J.MethodInvocation method) {
        boolean hasLambdaArgument = false;
        for (Expression arg : method.getArguments()) {
            if (!(arg instanceof J.Lambda)) continue;
            hasLambdaArgument = true;
            break;
        }
        return hasLambdaArgument;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

