/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class ExplicitLambdaArgumentTypes
extends Recipe {
    final String displayName = "Use explicit types on lambda arguments";
    final String description = "Adds explicit types on lambda arguments, which are otherwise optional. This can make the code clearer and easier to read. This does not add explicit types on arguments when the lambda has one or two parameters and does not have a block body, as things are considered more readable in those cases. For example, `stream.map((a, b) -> a.length);` will not have explicit types added.";
    final Set<String> tags = Collections.singleton("RSPEC-S2211");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ExplicitLambdaArgumentTypesVisitor();
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    private static class ExplicitLambdaArgumentTypesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private ExplicitLambdaArgumentTypesVisitor() {
        }

        public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext ctx) {
            J.Lambda l = super.visitLambda(lambda, (Object)ctx);
            if (l.getParameters().getParameters().size() <= 2 && !(l.getBody() instanceof J.Block)) {
                return l;
            }
            J.Lambda after = l.withParameters(l.getParameters().withParameters(ListUtils.map((List)l.getParameters().getParameters(), parameter -> {
                if (parameter instanceof J.VariableDeclarations) {
                    return this.maybeAddTypeExpression((J.VariableDeclarations)parameter);
                }
                return parameter;
            })));
            if (after != l) {
                after = after.withParameters(after.getParameters().withParenthesized(true));
            }
            return after;
        }

        private J.VariableDeclarations maybeAddTypeExpression(J.VariableDeclarations multiVariable) {
            J.VariableDeclarations.NamedVariable nv;
            TypeTree typeExpression;
            if (multiVariable.getTypeExpression() == null && (typeExpression = this.buildTypeTree((nv = (J.VariableDeclarations.NamedVariable)multiVariable.getVariables().get(0)).getType(), Space.EMPTY)) != null) {
                if (typeExpression instanceof J.Wildcard) {
                    J.Wildcard wildcard = (J.Wildcard)typeExpression;
                    if (wildcard.getBoundedType() == null) {
                        return multiVariable;
                    }
                    typeExpression = this.buildTypeTree(wildcard.getBoundedType().getType(), Space.EMPTY);
                }
                multiVariable = multiVariable.withTypeExpression(typeExpression);
                multiVariable = multiVariable.withVariables(ListUtils.map((List)multiVariable.getVariables(), (index, variable) -> {
                    if (index == 0) {
                        return variable.withPrefix(variable.getPrefix().withWhitespace(" "));
                    }
                    return variable;
                }));
            }
            return multiVariable;
        }

        private @Nullable TypeTree buildTypeTree(@Nullable JavaType type, Space space) {
            if (type == null || type instanceof JavaType.Unknown) {
                return null;
            }
            if (type instanceof JavaType.Primitive) {
                return new J.Primitive(Tree.randomId(), space, Markers.EMPTY, (JavaType.Primitive)type);
            }
            if (type instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified fq = (JavaType.FullyQualified)type;
                J.Identifier identifier = new J.Identifier(Tree.randomId(), space, Markers.EMPTY, Collections.emptyList(), fq.getClassName(), (JavaType)(type instanceof JavaType.Parameterized ? ((JavaType.Parameterized)type).getType() : type), null);
                if (!fq.getTypeParameters().isEmpty()) {
                    JContainer<Expression> typeParameters = this.buildTypeParameters(fq.getTypeParameters());
                    if (typeParameters == null) {
                        return null;
                    }
                    return new J.ParameterizedType(Tree.randomId(), space, Markers.EMPTY, (NameTree)identifier, typeParameters, (JavaType)new JavaType.Parameterized(null, fq, fq.getTypeParameters()));
                }
                this.maybeAddImport(fq);
                return identifier;
            }
            if (type instanceof JavaType.Array) {
                JavaType.Array arrayType = (JavaType.Array)type;
                JavaType elemType = arrayType.getElemType();
                while (elemType instanceof JavaType.Array) {
                    elemType = ((JavaType.Array)elemType).getElemType();
                }
                TypeTree result = this.buildTypeTree(elemType, space);
                if (result == null) {
                    return null;
                }
                JavaType currentType = type;
                while (currentType instanceof JavaType.Array) {
                    result = new J.ArrayType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, result, null, new JLeftPadded(Space.EMPTY, (Object)Space.EMPTY, Markers.EMPTY), currentType);
                    currentType = ((JavaType.Array)currentType).getElemType();
                }
                return result;
            }
            if (type instanceof JavaType.Variable) {
                return this.buildTypeTree(((JavaType.Variable)type).getType(), space);
            }
            if (type instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericType = (JavaType.GenericTypeVariable)type;
                if (!"?".equals(genericType.getName())) {
                    return new J.Identifier(Tree.randomId(), space, Markers.EMPTY, Collections.emptyList(), genericType.getName(), type, null);
                }
                JLeftPadded bound = null;
                TypeTree boundedType = null;
                if (genericType.getVariance() == JavaType.GenericTypeVariable.Variance.COVARIANT) {
                    bound = new JLeftPadded(Space.format((String)" "), (Object)J.Wildcard.Bound.Extends, Markers.EMPTY);
                } else if (genericType.getVariance() == JavaType.GenericTypeVariable.Variance.CONTRAVARIANT) {
                    bound = new JLeftPadded(Space.format((String)" "), (Object)J.Wildcard.Bound.Super, Markers.EMPTY);
                }
                if (!genericType.getBounds().isEmpty() && (boundedType = this.buildTypeTree((JavaType)genericType.getBounds().get(0), Space.format((String)" "))) == null) {
                    return null;
                }
                return new J.Wildcard(Tree.randomId(), space, Markers.EMPTY, bound, boundedType);
            }
            return null;
        }

        private @Nullable JContainer<Expression> buildTypeParameters(List<JavaType> typeParameters) {
            ArrayList<JRightPadded> typeExpressions = new ArrayList<JRightPadded>();
            for (JavaType type : typeParameters) {
                Expression typeParameterExpression = (Expression)this.buildTypeTree(type, Space.EMPTY);
                if (typeParameterExpression == null) {
                    return null;
                }
                typeExpressions.add(new JRightPadded((Object)typeParameterExpression, Space.EMPTY, Markers.EMPTY));
            }
            return JContainer.build((Space)Space.EMPTY, typeExpressions, (Markers)Markers.EMPTY);
        }
    }
}

