/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.CustomImportOrderStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.staticanalysis.CustomImportOrderVisitor;
import org.openrewrite.style.Style;

public class CustomImportOrder
extends Recipe {
    final String displayName = "Custom import order";
    final String description = "Updates and reorders Java import declarations according to group and order settings compatible with the Checkstyle 'CustomImportOrder' check.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                CustomImportOrderStyle style;
                if (tree instanceof JavaSourceFile && (style = (CustomImportOrderStyle)Style.from(CustomImportOrderStyle.class, (SourceFile)((JavaSourceFile)tree))) != null) {
                    return (J)new CustomImportOrderVisitor(style).visitNonNull(tree, ctx);
                }
                return (J)tree;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

