/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class CaseInsensitiveComparisonsDoNotChangeCase
extends Recipe {
    private static final MethodMatcher COMPARE_IGNORE_CASE_METHOD_MATCHER = new MethodMatcher("java.lang.String equalsIgnoreCase(java.lang.String)");
    private static final MethodMatcher TO_LOWER_CASE_METHOD_MATCHER = new MethodMatcher("java.lang.String toLowerCase()");
    private static final MethodMatcher TO_UPPER_CASE_METHOD_MATCHER = new MethodMatcher("java.lang.String toUpperCase()");
    final String displayName = "CaseInsensitive comparisons do not alter case";
    final String description = "Remove `String#toLowerCase()` or `String#toUpperCase()` from `String#equalsIgnoreCase(..)` comparisons.";
    final Set<String> tags = Collections.singleton("RSPEC-S1157");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(COMPARE_IGNORE_CASE_METHOD_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (COMPARE_IGNORE_CASE_METHOD_MATCHER.matches((MethodCall)mi) && this.isChangeCaseMethod((J)(mi = mi.withArguments(ListUtils.map((List)mi.getArguments(), arg -> {
                    if (arg instanceof J.MethodInvocation && this.isChangeCaseMethod((J)arg)) {
                        return ((J.MethodInvocation)arg).getSelect();
                    }
                    return arg;
                }))).getSelect())) {
                    J.MethodInvocation mChangeCase = (J.MethodInvocation)mi.getSelect();
                    mi = mi.withSelect(mChangeCase.getSelect());
                }
                return mi;
            }

            private boolean isChangeCaseMethod(@Nullable J j) {
                if (j instanceof J.MethodInvocation) {
                    J.MethodInvocation mi = (J.MethodInvocation)j;
                    return TO_LOWER_CASE_METHOD_MATCHER.matches((MethodCall)mi) || TO_UPPER_CASE_METHOD_MATCHER.matches((MethodCall)mi);
                }
                return false;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

