/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public class AbstractClassPublicConstructor
extends Recipe {
    final String displayName = "Constructors of an `abstract` class should not be declared `public`";
    final String description = "Constructors of `abstract` classes can only be called in constructors of their subclasses. Therefore the visibility of `public` constructors are reduced to `protected`.";
    final Set<String> tags = Collections.singleton("RSPEC-S5993");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.hasModifier(J.Modifier.Type.Abstract)) {
                    return cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), st -> {
                        if (st instanceof J.MethodDeclaration && ((J.MethodDeclaration)st).isConstructor()) {
                            return ((J.MethodDeclaration)st).withModifiers(ListUtils.map((List)((J.MethodDeclaration)st).getModifiers(), mod -> mod.getType() == J.Modifier.Type.Public ? mod.withType(J.Modifier.Type.Protected) : mod));
                        }
                        return st;
                    })));
                }
                return cd;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

