/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RenameVariable;
import org.openrewrite.java.cleanup.RenameJavaDocParamNameVisitor;
import org.openrewrite.java.style.HiddenFieldStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="7.6.0")
public final class HiddenFieldVisitor<P>
extends JavaIsoVisitor<P> {
    private static final Pattern NEXT_NAME_PATTERN = Pattern.compile("(.+)(\\d+)");
    private final HiddenFieldStyle style;

    private static Cursor getCursorToParentScope(Cursor cursor) {
        return cursor.dropParentUntil(is -> is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda);
    }

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        List<J.VariableDeclarations.NamedVariable> classFields = classDecl.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).flatMap(vd -> vd.getVariables().stream()).collect(Collectors.toList());
        classFields.forEach(cf -> FindNameShadows.find((J)classDecl, cf, classDecl, this.style).forEach(shadow -> this.doAfterVisit((TreeVisitor)new RenameShadowedName((J.VariableDeclarations.NamedVariable)shadow, this.style))));
        return super.visitClassDeclaration(classDecl, p);
    }

    @Generated
    public HiddenFieldVisitor(HiddenFieldStyle style) {
        this.style = style;
    }

    @Generated
    public HiddenFieldStyle getStyle() {
        return this.style;
    }

    @Generated
    public String toString() {
        return "HiddenFieldVisitor(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HiddenFieldVisitor)) {
            return false;
        }
        HiddenFieldVisitor other = (HiddenFieldVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        HiddenFieldStyle this$style = this.getStyle();
        HiddenFieldStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HiddenFieldVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HiddenFieldStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }

    private static class FindNameShadows
    extends JavaIsoVisitor<Set<J.VariableDeclarations.NamedVariable>> {
        private final J.VariableDeclarations.NamedVariable targetVariable;
        private final J.ClassDeclaration targetVariableEnclosingClass;
        private final HiddenFieldStyle hiddenFieldStyle;

        public FindNameShadows(J.VariableDeclarations.NamedVariable targetVariable, J.ClassDeclaration targetVariableEnclosingClass, HiddenFieldStyle hiddenFieldStyle) {
            this.targetVariable = targetVariable;
            this.targetVariableEnclosingClass = targetVariableEnclosingClass;
            this.hiddenFieldStyle = hiddenFieldStyle;
        }

        public static Set<J.VariableDeclarations.NamedVariable> find(J j, J.VariableDeclarations.NamedVariable targetVariable, J.ClassDeclaration targetVariableEnclosingClass, HiddenFieldStyle hiddenFieldStyle) {
            LinkedHashSet<J.VariableDeclarations.NamedVariable> references = new LinkedHashSet<J.VariableDeclarations.NamedVariable>();
            new FindNameShadows(targetVariable, targetVariableEnclosingClass, hiddenFieldStyle).visit((Tree)j, references);
            return references;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Set<J.VariableDeclarations.NamedVariable> ctx) {
            if (classDecl.getKind() != J.ClassDeclaration.Kind.Type.Class || classDecl.hasModifier(J.Modifier.Type.Static)) {
                return classDecl;
            }
            return super.visitClassDeclaration(classDecl, ctx);
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Set<J.VariableDeclarations.NamedVariable> ctx) {
            if (method.hasModifier(J.Modifier.Type.Static)) {
                return method;
            }
            return super.visitMethodDeclaration(method, ctx);
        }

        public J.Block visitBlock(J.Block block, Set<J.VariableDeclarations.NamedVariable> ctx) {
            if (block.isStatic()) {
                return block;
            }
            return super.visitBlock(block, ctx);
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Set<J.VariableDeclarations.NamedVariable> ctx) {
            J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, ctx);
            if (v.getSimpleName().equals(this.targetVariable.getSimpleName()) && !v.isScope((Tree)this.targetVariable)) {
                boolean isIgnorableAbstractMethod;
                Tree maybeMethodDecl = (Tree)this.getCursor().getParentTreeCursor().getParentTreeCursor().getValue();
                boolean isIgnorableConstructorParam = this.hiddenFieldStyle.getIgnoreConstructorParameter();
                if (isIgnorableConstructorParam) {
                    isIgnorableConstructorParam = maybeMethodDecl instanceof J.MethodDeclaration && ((J.MethodDeclaration)maybeMethodDecl).isConstructor();
                }
                boolean isIgnorableSetter = this.hiddenFieldStyle.getIgnoreSetter();
                if (isIgnorableSetter &= maybeMethodDecl instanceof J.MethodDeclaration) {
                    boolean doesMethodNameCorrespondToVariable;
                    J.MethodDeclaration md = (J.MethodDeclaration)maybeMethodDecl;
                    boolean doesSetterReturnItsClass = md.getReturnTypeExpression() != null && TypeUtils.isOfType((JavaType)this.targetVariableEnclosingClass.getType(), (JavaType)md.getReturnTypeExpression().getType());
                    boolean isSetterVoid = md.getReturnTypeExpression() != null && JavaType.Primitive.Void == md.getReturnTypeExpression().getType();
                    boolean bl = doesMethodNameCorrespondToVariable = md.getSimpleName().startsWith("set") && md.getSimpleName().toLowerCase().endsWith(variable.getSimpleName().toLowerCase());
                    boolean bl2 = doesMethodNameCorrespondToVariable && (this.hiddenFieldStyle.getSetterCanReturnItsClass() != false ? doesSetterReturnItsClass || isSetterVoid : isSetterVoid) ? true : (isIgnorableSetter = false);
                }
                if (isIgnorableAbstractMethod = this.hiddenFieldStyle.getIgnoreAbstractMethods().booleanValue()) {
                    boolean bl = isIgnorableAbstractMethod = maybeMethodDecl instanceof J.MethodDeclaration && ((J.MethodDeclaration)maybeMethodDecl).isAbstract();
                }
                if (!(isIgnorableSetter || isIgnorableConstructorParam || isIgnorableAbstractMethod)) {
                    ctx.add(v);
                }
            }
            return v;
        }
    }

    private static class RenameShadowedName<P>
    extends JavaIsoVisitor<P> {
        private final J.VariableDeclarations.NamedVariable targetVariable;
        private final HiddenFieldStyle hiddenFieldStyle;

        public RenameShadowedName(J.VariableDeclarations.NamedVariable targetVariable, HiddenFieldStyle hiddenFieldStyle) {
            this.targetVariable = targetVariable;
            this.hiddenFieldStyle = hiddenFieldStyle;
        }

        private static String nextName(String name) {
            Matcher nameMatcher = NEXT_NAME_PATTERN.matcher(name);
            return nameMatcher.matches() ? nameMatcher.group(1) + (Integer.parseInt(nameMatcher.group(2)) + 1) : name + "1";
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
            J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, p);
            if (v.isScope((Tree)this.targetVariable)) {
                String nextName = RenameShadowedName.nextName(v.getSimpleName());
                JavaSourceFile enclosingCU = (JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class);
                Cursor parentScope = HiddenFieldVisitor.getCursorToParentScope(this.getCursor());
                J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (enclosingClass == null) {
                    return v;
                }
                while (!FindNameShadows.find((J)parentScope.getValue(), v.withName(v.getName().withSimpleName(nextName)), enclosingClass, this.hiddenFieldStyle).isEmpty() || !FindExistingVariableDeclarations.find((J)enclosingCU, this.getCursor(), nextName).isEmpty()) {
                    nextName = RenameShadowedName.nextName(nextName);
                }
                this.doAfterVisit((TreeVisitor)new RenameVariable(v, nextName));
                if (parentScope.getValue() instanceof J.MethodDeclaration) {
                    Optional<J.VariableDeclarations> variableParameter = ((J.MethodDeclaration)parentScope.getValue()).getParameters().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).filter(it -> it.getVariables().contains(v)).findFirst();
                    if (variableParameter.isPresent()) {
                        this.doAfterVisit((TreeVisitor)new RenameJavaDocParamNameVisitor((J.MethodDeclaration)parentScope.getValue(), v.getSimpleName(), nextName));
                    }
                }
            }
            return v;
        }
    }

    private static class FindExistingVariableDeclarations
    extends JavaIsoVisitor<Set<J.VariableDeclarations.NamedVariable>> {
        private final Cursor childTargetReference;
        private final String childTargetName;

        private FindExistingVariableDeclarations(Cursor childTargetReference, String childTargetName) {
            this.childTargetReference = childTargetReference;
            this.childTargetName = childTargetName;
        }

        public static Set<J.VariableDeclarations.NamedVariable> find(J j, Cursor childTargetReference, String childTargetName) {
            LinkedHashSet<J.VariableDeclarations.NamedVariable> references = new LinkedHashSet<J.VariableDeclarations.NamedVariable>();
            new FindExistingVariableDeclarations(childTargetReference, childTargetName).visit((Tree)j, references);
            return references;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Set<J.VariableDeclarations.NamedVariable> ctx) {
            if (variable.getSimpleName().equals(this.childTargetName) && this.isInSameNameScope(this.getCursor(), this.childTargetReference)) {
                ctx.add(variable);
            }
            return super.visitVariable(variable, ctx);
        }
    }
}

