/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.DeleteStatement;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.format.ShiftFormat;
import org.openrewrite.java.style.EmptyBlockStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public final class EmptyBlockVisitor<P>
extends JavaIsoVisitor<P> {
    private final EmptyBlockStyle emptyBlockStyle;
    private final JavaTemplate continueStatement = JavaTemplate.builder((String)"continue;").build();

    public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
        J.WhileLoop w = super.visitWhileLoop(whileLoop, p);
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralWhile()) && this.isEmptyBlock(w.getBody())) {
            J.Block body = (J.Block)w.getBody();
            w = (J.WhileLoop)this.continueStatement.apply(this.updateCursor((Tree)w), body.getCoordinates().lastStatement(), new Object[0]);
        }
        return w;
    }

    public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        J.DoWhileLoop w = super.visitDoWhileLoop(doWhileLoop, p);
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralWhile()) && this.isEmptyBlock(w.getBody())) {
            J.Block body = (J.Block)w.getBody();
            w = (J.DoWhileLoop)this.continueStatement.apply(this.updateCursor((Tree)w), body.getCoordinates().lastStatement(), new Object[0]);
        }
        return w;
    }

    public J.Block visitBlock(J.Block block, P p) {
        J.Block b = super.visitBlock(block, p);
        AtomicBoolean filtered = new AtomicBoolean(false);
        List statements = ListUtils.map((List)b.getStatements(), s -> {
            if (!(s instanceof J.Block)) {
                return s;
            }
            J.Block nestedBlock = (J.Block)s;
            if (this.isEmptyBlock((Statement)nestedBlock) && (Boolean.TRUE.equals(this.emptyBlockStyle.getStaticInit()) && nestedBlock.isStatic() || Boolean.TRUE.equals(this.emptyBlockStyle.getInstanceInit()) && !nestedBlock.isStatic())) {
                filtered.set(true);
                return null;
            }
            return nestedBlock;
        });
        return filtered.get() ? b.withStatements(statements) : b;
    }

    public J.Try visitTry(J.Try tryable, P p) {
        J.Try t = super.visitTry(tryable, p);
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralTry()) && this.isEmptyBlock((Statement)t.getBody()) && this.isEmptyResources(t.getResources())) {
            this.doAfterVisit((TreeVisitor)new DeleteStatement((Statement)tryable));
        } else if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralFinally()) && t.getFinally() != null && !t.getCatches().isEmpty() && this.isEmptyBlock((Statement)t.getFinally())) {
            t = t.withFinally(null);
        }
        return t;
    }

    public J.If visitIf(J.If iff, P p) {
        J.If i = super.visitIf(iff, p);
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralElse()) && i.getElsePart() != null && this.isEmptyBlock(i.getElsePart().getBody())) {
            i = i.withElsePart(null);
        }
        if (Boolean.FALSE.equals(this.emptyBlockStyle.getLiteralIf()) || !this.isEmptyBlock(i.getThenPart())) {
            return i;
        }
        if (i.getElsePart() == null) {
            J.Block enclosingBlock = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
            if (enclosingBlock != null) {
                this.doAfterVisit((TreeVisitor)new ExtractSideEffectsOfIfCondition(enclosingBlock, i));
            }
            return i;
        }
        J.ControlParentheses cond = i.getIfCondition();
        if (!(cond.getTree() instanceof J.Binary)) {
            return i;
        }
        J.Binary binary = (J.Binary)cond.getTree();
        switch (binary.getOperator()) {
            case Equal: {
                cond = cond.withTree((J)binary.withOperator(J.Binary.Type.NotEqual));
                break;
            }
            case NotEqual: {
                cond = cond.withTree((J)binary.withOperator(J.Binary.Type.Equal));
                break;
            }
            case LessThan: {
                cond = cond.withTree((J)binary.withOperator(J.Binary.Type.GreaterThanOrEqual));
                break;
            }
            case LessThanOrEqual: {
                cond = cond.withTree((J)binary.withOperator(J.Binary.Type.GreaterThan));
                break;
            }
            case GreaterThan: {
                cond = cond.withTree((J)binary.withOperator(J.Binary.Type.LessThanOrEqual));
                break;
            }
            case GreaterThanOrEqual: {
                cond = cond.withTree((J)binary.withOperator(J.Binary.Type.LessThan));
                break;
            }
        }
        i = i.withIfCondition(cond);
        if (i.getElsePart() == null) {
            return i.withThenPart((Statement)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withElsePart(null);
        }
        J.Block thenPart = (J.Block)i.getThenPart();
        Statement elseStatement = i.getElsePart().getBody();
        List<Statement> elseStatementBody = elseStatement instanceof J.Block ? ((J.Block)elseStatement).getStatements() : (elseStatement instanceof J.If ? Collections.singletonList((Statement)ShiftFormat.indent((J)elseStatement.withPrefix(Space.format((String)("\n" + i.getPrefix().getIndent()))), (Cursor)this.getCursor(), (int)1)) : Collections.singletonList((Statement)ShiftFormat.indent((J)elseStatement, (Cursor)this.getCursor(), (int)1)));
        return i.withThenPart((Statement)thenPart.withStatements((List)elseStatementBody)).withElsePart(null);
    }

    public J.Synchronized visitSynchronized(J.Synchronized synch, P p) {
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralSynchronized()) && this.isEmptyBlock((Statement)synch.getBody())) {
            this.doAfterVisit((TreeVisitor)new DeleteStatement((Statement)synch));
        }
        return super.visitSynchronized(synch, p);
    }

    public J.Switch visitSwitch(J.Switch switch_, P p) {
        if (Boolean.TRUE.equals(this.emptyBlockStyle.getLiteralSwitch()) && this.isEmptyBlock((Statement)switch_.getCases())) {
            this.doAfterVisit((TreeVisitor)new DeleteStatement((Statement)switch_));
        }
        return super.visitSwitch(switch_, p);
    }

    private boolean isEmptyBlock(Statement blockNode) {
        if (blockNode instanceof J.Block) {
            J.Block block = (J.Block)blockNode;
            if (EmptyBlockStyle.BlockPolicy.STATEMENT == this.emptyBlockStyle.getBlockPolicy()) {
                return block.getStatements().isEmpty();
            }
            if (EmptyBlockStyle.BlockPolicy.TEXT == this.emptyBlockStyle.getBlockPolicy()) {
                return block.getStatements().isEmpty() && block.getEnd().getComments().isEmpty();
            }
        }
        return false;
    }

    private boolean isEmptyResources(@Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    J.Try.Resource> resources) {
        return resources == null || resources.isEmpty();
    }

    @Generated
    public EmptyBlockVisitor(EmptyBlockStyle emptyBlockStyle) {
        this.emptyBlockStyle = emptyBlockStyle;
    }

    @Generated
    public EmptyBlockStyle getEmptyBlockStyle() {
        return this.emptyBlockStyle;
    }

    @Generated
    public JavaTemplate getContinueStatement() {
        return this.continueStatement;
    }

    @Generated
    public String toString() {
        return "EmptyBlockVisitor(emptyBlockStyle=" + this.getEmptyBlockStyle() + ", continueStatement=" + this.getContinueStatement() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmptyBlockVisitor)) {
            return false;
        }
        EmptyBlockVisitor other = (EmptyBlockVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EmptyBlockStyle this$emptyBlockStyle = this.getEmptyBlockStyle();
        EmptyBlockStyle other$emptyBlockStyle = other.getEmptyBlockStyle();
        if (this$emptyBlockStyle == null ? other$emptyBlockStyle != null : !this$emptyBlockStyle.equals(other$emptyBlockStyle)) {
            return false;
        }
        JavaTemplate this$continueStatement = this.getContinueStatement();
        JavaTemplate other$continueStatement = other.getContinueStatement();
        return !(this$continueStatement == null ? other$continueStatement != null : !this$continueStatement.equals(other$continueStatement));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmptyBlockVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EmptyBlockStyle $emptyBlockStyle = this.getEmptyBlockStyle();
        result = result * 59 + ($emptyBlockStyle == null ? 43 : $emptyBlockStyle.hashCode());
        JavaTemplate $continueStatement = this.getContinueStatement();
        result = result * 59 + ($continueStatement == null ? 43 : $continueStatement.hashCode());
        return result;
    }

    private static class ExtractSideEffectsOfIfCondition<P>
    extends JavaVisitor<P> {
        private final J.Block enclosingBlock;
        private final J.If toExtract;

        public ExtractSideEffectsOfIfCondition(J.Block enclosingBlock, J.If toExtract) {
            this.enclosingBlock = enclosingBlock;
            this.toExtract = toExtract;
        }

        public J visitBlock(J.Block block, P p) {
            J.Block b = (J.Block)super.visitBlock(block, p);
            if (this.enclosingBlock.isScope((Tree)block)) {
                ArrayList<Statement> statements = new ArrayList<Statement>(b.getStatements().size());
                for (Statement statement : b.getStatements()) {
                    if (statement == this.toExtract) {
                        for (J sideEffect : ((Expression)this.toExtract.getIfCondition().getTree()).getSideEffects()) {
                            sideEffect = this.autoFormat(sideEffect, p, this.getCursor());
                            statements.add((Statement)sideEffect);
                        }
                        continue;
                    }
                    statements.add(statement);
                }
                b = b.withStatements(statements);
            }
            return b;
        }
    }
}

