/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class DeclarationSiteTypeVariance
extends Recipe {
    @Option(displayName="Variant types", description="A list of well-known classes that have in/out type variance.", example="java.util.function.Function<IN, OUT>")
    private final List<String> variantTypes;
    @Option(displayName="Excluded bounds", description="A list of bounds that should not receive explicit variance. Globs supported.", example="java.lang.*", required=false)
    @Nullable
    private final List<String> excludedBounds;
    @Option(displayName="Exclude final classes", description="If true, do not add `? extends` variance to final classes. `? super` variance will be added regardless of finality.", required=false)
    @Nullable
    private final Boolean excludeFinalClasses;

    public String getDisplayName() {
        return "Properly use declaration-site type variance";
    }

    public String getDescription() {
        return "Currently, Java requires use-site type variance, so if someone has `Function<IN, OUT>` method parameter, it should rather be `Function<? super IN, ? extends OUT>`. Unfortunately, it is not easy to notice that `? super` and `? extends` is missing, so this recipe adds it where that would improve the situation.";
    }

    public Validated validate() {
        Validated v = super.validate();
        if ((v = v.and(Validated.required((String)"variantTypes", this.variantTypes))).isValid()) {
            for (String variantType : this.variantTypes) {
                v = v.and(Validated.test((String)"variantTypes", (String)"Must be a valid variant type", (Object)variantType, vt -> {
                    try {
                        VariantTypeSpec.build(vt);
                        return true;
                    }
                    catch (Throwable ignored) {
                        return false;
                    }
                }));
            }
        }
        return v;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final List variantTypeSpecs = this.variantTypes.stream().map(VariantTypeSpec::build).collect(Collectors.toList());
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
                if (m.getMethodType() != null && m.getMethodType().isOverride()) {
                    return m;
                }
                return m.withParameters(ListUtils.map((List)m.getParameters(), param -> {
                    J.VariableDeclarations varParam;
                    if (param instanceof J.VariableDeclarations && (varParam = (J.VariableDeclarations)param).getTypeExpression() instanceof J.ParameterizedType) {
                        J.ParameterizedType pt = (J.ParameterizedType)varParam.getTypeExpression();
                        for (VariantTypeSpec variantTypeSpec : variantTypeSpecs) {
                            if (!variantTypeSpec.hasType(pt)) continue;
                            return varParam.withTypeExpression((TypeTree)this.useDeclarationSiteVariance(pt, variantTypeSpec));
                        }
                    }
                    return param;
                }));
            }

            private J.ParameterizedType useDeclarationSiteVariance(J.ParameterizedType pt, VariantTypeSpec spec) {
                return pt.withTypeParameters(ListUtils.map((List)pt.getTypeParameters(), (i, tp) -> {
                    VariantTypeSpec.Variance variance = spec.getVariances().get((int)i);
                    if (tp instanceof J.Wildcard || !(tp instanceof NameTree) || variance == VariantTypeSpec.Variance.INVARIANT) {
                        return tp;
                    }
                    JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)tp.getType());
                    if (fq != null) {
                        if (DeclarationSiteTypeVariance.this.excludedBounds != null) {
                            for (String excludedBound : DeclarationSiteTypeVariance.this.excludedBounds) {
                                if (!StringUtils.matchesGlob((String)fq.getFullyQualifiedName(), (String)excludedBound)) continue;
                                return tp;
                            }
                        }
                        if (Boolean.TRUE.equals(DeclarationSiteTypeVariance.this.excludeFinalClasses) && fq.getFlags().contains(Flag.Final) && variance == VariantTypeSpec.Variance.OUT) {
                            return tp;
                        }
                    }
                    return new J.Wildcard(Tree.randomId(), tp.getPrefix(), Markers.EMPTY, JLeftPadded.build((Object)(variance == VariantTypeSpec.Variance.OUT ? J.Wildcard.Bound.Extends : J.Wildcard.Bound.Super)).withBefore(Space.format((String)" ")), (NameTree)tp.withPrefix(Space.format((String)" ")));
                }));
            }
        };
    }

    public DeclarationSiteTypeVariance(List<String> variantTypes, List<String> excludedBounds, Boolean excludeFinalClasses) {
        this.variantTypes = variantTypes;
        this.excludedBounds = excludedBounds;
        this.excludeFinalClasses = excludeFinalClasses;
    }

    public List<String> getVariantTypes() {
        return this.variantTypes;
    }

    public List<String> getExcludedBounds() {
        return this.excludedBounds;
    }

    public Boolean getExcludeFinalClasses() {
        return this.excludeFinalClasses;
    }

    public String toString() {
        return "DeclarationSiteTypeVariance(variantTypes=" + this.getVariantTypes() + ", excludedBounds=" + this.getExcludedBounds() + ", excludeFinalClasses=" + this.getExcludeFinalClasses() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeclarationSiteTypeVariance)) {
            return false;
        }
        DeclarationSiteTypeVariance other = (DeclarationSiteTypeVariance)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$excludeFinalClasses = this.getExcludeFinalClasses();
        Boolean other$excludeFinalClasses = other.getExcludeFinalClasses();
        if (this$excludeFinalClasses == null ? other$excludeFinalClasses != null : !((Object)this$excludeFinalClasses).equals(other$excludeFinalClasses)) {
            return false;
        }
        List<String> this$variantTypes = this.getVariantTypes();
        List<String> other$variantTypes = other.getVariantTypes();
        if (this$variantTypes == null ? other$variantTypes != null : !((Object)this$variantTypes).equals(other$variantTypes)) {
            return false;
        }
        List<String> this$excludedBounds = this.getExcludedBounds();
        List<String> other$excludedBounds = other.getExcludedBounds();
        return !(this$excludedBounds == null ? other$excludedBounds != null : !((Object)this$excludedBounds).equals(other$excludedBounds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeclarationSiteTypeVariance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $excludeFinalClasses = this.getExcludeFinalClasses();
        result = result * 59 + ($excludeFinalClasses == null ? 43 : ((Object)$excludeFinalClasses).hashCode());
        List<String> $variantTypes = this.getVariantTypes();
        result = result * 59 + ($variantTypes == null ? 43 : ((Object)$variantTypes).hashCode());
        List<String> $excludedBounds = this.getExcludedBounds();
        result = result * 59 + ($excludedBounds == null ? 43 : ((Object)$excludedBounds).hashCode());
        return result;
    }

    private static final class VariantTypeSpec {
        private final String fullyQualifiedName;
        private final List<Variance> variances;

        public boolean hasType(J.ParameterizedType pt) {
            return TypeUtils.isOfClassType((JavaType)pt.getType(), (String)this.fullyQualifiedName);
        }

        public static VariantTypeSpec build(String pattern) {
            String fqn = pattern.substring(0, pattern.indexOf(60));
            String variancesStr = pattern.substring(pattern.indexOf(60) + 1, pattern.lastIndexOf(62));
            return new VariantTypeSpec(fqn, Arrays.stream(variancesStr.split(",")).map(String::trim).map(Variance::valueOf).collect(Collectors.toList()));
        }

        public VariantTypeSpec(String fullyQualifiedName, List<Variance> variances) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.variances = variances;
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public List<Variance> getVariances() {
            return this.variances;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariantTypeSpec)) {
                return false;
            }
            VariantTypeSpec other = (VariantTypeSpec)o;
            String this$fullyQualifiedName = this.getFullyQualifiedName();
            String other$fullyQualifiedName = other.getFullyQualifiedName();
            if (this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName)) {
                return false;
            }
            List<Variance> this$variances = this.getVariances();
            List<Variance> other$variances = other.getVariances();
            return !(this$variances == null ? other$variances != null : !((Object)this$variances).equals(other$variances));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedName = this.getFullyQualifiedName();
            result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
            List<Variance> $variances = this.getVariances();
            result = result * 59 + ($variances == null ? 43 : ((Object)$variances).hashCode());
            return result;
        }

        public String toString() {
            return "DeclarationSiteTypeVariance.VariantTypeSpec(fullyQualifiedName=" + this.getFullyQualifiedName() + ", variances=" + this.getVariances() + ")";
        }

        static enum Variance {
            IN,
            OUT,
            INVARIANT;

        }
    }
}

