/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.math.BigDecimal;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="`new BigDecimal(double)` should not be used", description="Use of `new BigDecimal(double)` constructor can lead to loss of precision. Use `BigDecimal.valueOf(double)` instead.\nFor example writing `new BigDecimal(0.1)` does not create a `BigDecimal` which is exactly equal to `0.1`, but it is equal to `0.1000000000000000055511151231257827021181583404541015625`. This is because `0.1` cannot be represented exactly as a double (or, for that matter, as a binary fraction of any finite length).", tags={"RSPEC-2111"})
public class BigDecimalDoubleConstructor {
    BigDecimal bigDecimalDoubleConstructor(double d) {
        return new BigDecimal(d);
    }

    BigDecimal bigDecimalValueOf(double d) {
        return BigDecimal.valueOf(d);
    }
}

