/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.dataflow.FindLocalFlowPaths;
import org.openrewrite.analysis.dataflow.LocalFlowSpec;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ReplaceStackWithDeque
extends Recipe {
    public String getDisplayName() {
        return "Replace `java.util.Stack` with `java.util.Deque`";
    }

    public String getDescription() {
        return "From the Javadoc of `Stack`:\n> A more complete and consistent set of LIFO stack operations is provided by the Deque interface and its implementations, which should be used in preference to this class.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("java.util.Stack", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations.NamedVariable visitVariable(final J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)ctx);
                LocalFlowSpec<Expression, J> returned = new LocalFlowSpec<Expression, J>(){

                    public boolean isSource(Expression expression, Cursor cursor) {
                        return variable.getInitializer() == expression;
                    }

                    public boolean isSink(J j, Cursor cursor) {
                        return cursor.firstEnclosing(J.Return.class) != null;
                    }
                };
                if (v.getInitializer() != null && FindLocalFlowPaths.noneMatch((Cursor)this.getCursor(), (LocalFlowSpec)returned)) {
                    v = (J.VariableDeclarations.NamedVariable)new ChangeType("java.util.Stack", "java.util.ArrayDeque", Boolean.valueOf(false)).getVisitor().visitNonNull((Tree)v, (Object)ctx, this.getCursor().getParentOrThrow());
                    this.getCursor().putMessageOnFirstEnclosing(J.VariableDeclarations.class, "replace", (Object)true);
                }
                return v;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations v = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (((Boolean)this.getCursor().getMessage("replace", (Object)false)).booleanValue()) {
                    v = (J.VariableDeclarations)new ChangeType("java.util.Stack", "java.util.Deque", Boolean.valueOf(false)).getVisitor().visitNonNull((Tree)v, (Object)ctx, this.getCursor().getParentOrThrow());
                    this.maybeAddImport("java.util.ArrayDeque");
                    this.maybeAddImport("java.util.Deque");
                }
                return v;
            }
        });
    }
}

