/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.openapi.swagger;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

class MigrateApiParamSchemaValue
extends JavaIsoVisitor<ExecutionContext> {
    private static final String FQN_SCHEMA = "io.swagger.v3.oas.annotations.media.Schema";
    private static final AnnotationMatcher PARAMETER_ANNOTATION_MATCHER = new AnnotationMatcher("io.swagger.v3.oas.annotations.Parameter");
    private final String attribute;

    public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
        J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
        if (!PARAMETER_ANNOTATION_MATCHER.matches(a)) {
            return a;
        }
        StringBuilder tpl = new StringBuilder();
        ArrayList<Expression> args = new ArrayList<Expression>();
        SchemaInfo schemaInfo = new SchemaInfo();
        for (Expression exp : a.getArguments()) {
            if (this.isAttributeAssignment(exp)) {
                Expression expression = ((J.Assignment)exp).getAssignment();
                String schema = this.createSchema(this.attribute);
                schemaInfo.genSchema(schema, expression);
                continue;
            }
            if (this.isSchemaAssignment(exp)) {
                schemaInfo.existingSchema((J.Assignment)exp);
                continue;
            }
            tpl.append("#{any()}, ");
            args.add(exp);
        }
        schemaInfo.process(tpl, args);
        if (tpl.toString().endsWith(", ")) {
            tpl.delete(tpl.length() - 2, tpl.length());
        }
        this.maybeAddImport(FQN_SCHEMA, false);
        a = (J.Annotation)JavaTemplate.builder((String)tpl.toString()).imports(new String[]{FQN_SCHEMA}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"swagger-annotations"})).build().apply(this.updateCursor((Tree)a), annotation.getCoordinates().replaceArguments(), args.toArray());
        return (J.Annotation)this.maybeAutoFormat((J)annotation, (J)a, ctx, this.getCursor().getParentTreeCursor());
    }

    private boolean isSchemaAssignment(Expression expr) {
        Expression vble;
        if (expr instanceof J.Assignment && (vble = ((J.Assignment)expr).getVariable()) instanceof J.Identifier) {
            return "schema".equals(((J.Identifier)vble).getSimpleName());
        }
        return false;
    }

    private String createSchema(String schemaVble) {
        return String.format("schema = @Schema(%s = #{any()} ", schemaVble);
    }

    private boolean isAttributeAssignment(Expression exp) {
        return exp instanceof J.Assignment && this.attribute.equals(((J.Identifier)((J.Assignment)exp).getVariable()).getSimpleName());
    }

    @Generated
    public MigrateApiParamSchemaValue(String attribute) {
        this.attribute = attribute;
    }

    private static class SchemaInfo {
        private @Nullable Expression schemaExpr;
        private @Nullable String schemaStr;
        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Assignment existingSchemaExpr;

        private SchemaInfo() {
        }

        private void genSchema(String schemaStr, Expression schemaExpr) {
            this.schemaExpr = schemaExpr;
            this.schemaStr = schemaStr;
        }

        private void existingSchema(J.Assignment existingSchemaExpr) {
            this.existingSchemaExpr = existingSchemaExpr;
        }

        private void process(StringBuilder tpl, List<Expression> args) {
            if (this.schemaStr == null) {
                if (this.existingSchemaExpr != null) {
                    args.add((Expression)this.existingSchemaExpr);
                }
            } else {
                tpl.append(this.schemaStr);
                if (this.existingSchemaExpr != null && this.existingSchemaExpr.getAssignment() instanceof J.Annotation) {
                    for (Expression schemaArg : ((J.Annotation)this.existingSchemaExpr.getAssignment()).getArguments()) {
                        tpl.append(", ").append(schemaArg);
                    }
                }
                tpl.append(")");
                args.add(this.schemaExpr);
            }
        }
    }
}

