/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.openapi.swagger;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

final class AnnotationUtils {
    public static Map<String, Expression> extractArgumentAssignedExpressions(J.Annotation annotation) {
        return AnnotationUtils.extractArguments(annotation, J.Assignment::getAssignment);
    }

    public static Map<String, J.Assignment> extractArgumentAssignments(J.Annotation annotation) {
        return AnnotationUtils.extractArguments(annotation, Function.identity());
    }

    private static <T> Map<String, T> extractArguments(J.Annotation annotation, Function<J.Assignment, T> extractor) {
        if (annotation.getArguments() == null || annotation.getArguments().isEmpty() || annotation.getArguments().get(0) instanceof J.Empty) {
            return Collections.emptyMap();
        }
        HashMap<String, T> map = new HashMap<String, T>();
        for (Expression expression : annotation.getArguments()) {
            if (!(expression instanceof J.Assignment)) continue;
            J.Assignment a = (J.Assignment)expression;
            map.put(((J.Identifier)a.getVariable()).getSimpleName(), extractor.apply(a));
        }
        return map;
    }

    @Generated
    private AnnotationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

