/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.search;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.migrate.table.JavaVersionMigrationPlan;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Markers;

public class PlanJavaMigration
extends ScanningRecipe<JavaVersionMigrationPlan.Row.Builder> {
    transient JavaVersionMigrationPlan plan = new JavaVersionMigrationPlan((Recipe)this);
    final String displayName = "Plan a Java version migration";
    final String description = "Study the set of Java versions and associated tools in use across many repositories.";

    public JavaVersionMigrationPlan.Row.Builder getInitialValue(ExecutionContext ctx) {
        return JavaVersionMigrationPlan.Row.builder();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final JavaVersionMigrationPlan.Row.Builder acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    File sourceFile = ((SourceFile)tree).getSourcePath().toFile();
                    if (sourceFile.getName().contains("build.gradle")) {
                        acc.hasGradleBuild(true);
                    } else if (sourceFile.getName().contains("pom.xml")) {
                        acc.hasMavenPom(true);
                    }
                }
                if (tree instanceof JavaSourceFile) {
                    acc.hasJava(true);
                    Markers markers = tree.getMarkers();
                    markers.findFirst(JavaVersion.class).ifPresent(javaVersion -> {
                        acc.sourceCompatibility(javaVersion.getSourceCompatibility());
                        acc.majorVersionSourceCompatibility(javaVersion.getMajorVersion());
                        acc.targetCompatibility(javaVersion.getTargetCompatibility());
                    });
                    markers.findFirst(BuildTool.class).ifPresent(buildTool -> {
                        switch (buildTool.getType()) {
                            case Gradle: {
                                acc.gradleVersion(buildTool.getVersion());
                                break;
                            }
                            case Maven: {
                                acc.mavenVersion(buildTool.getVersion());
                            }
                        }
                    });
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(JavaVersionMigrationPlan.Row.Builder acc, ExecutionContext ctx) {
        this.plan.insertRow(ctx, acc.build());
        return Collections.emptyList();
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

