/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class AddTransientAnnotationToEntity
extends ScanningRecipe<EntityAccumulator> {
    private final String displayName = "Unannotated entity attributes require a Transient annotation";
    private final String description = "In OpenJPA, attributes that are themselves entity classes are not persisted by default. EclipseLink has a different default behavior and tries to persist these attributes to the database. To keep the OpenJPA behavior of ignoring unannotated entity attributes, add the `javax.persistence.Transient` annotation to these attributes in EclipseLink.";

    public EntityAccumulator getInitialValue(ExecutionContext ctx) {
        return new EntityAccumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final EntityAccumulator acc) {
        return Preconditions.check((TreeVisitor)new UsesType("javax.persistence.Entity", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (FindAnnotations.find((J)classDecl, (String)"javax.persistence.Entity").isEmpty()) {
                    return classDecl;
                }
                JavaType.FullyQualified type = classDecl.getType();
                if (type != null) {
                    acc.addEntity((JavaType)type);
                }
                return classDecl;
            }
        });
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final EntityAccumulator acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (!acc.isEntity(multiVariable.getType())) {
                    return multiVariable;
                }
                if (multiVariable.getLeadingAnnotations().stream().anyMatch(anno -> anno.getType().toString().contains("javax.persistence"))) {
                    return multiVariable;
                }
                this.maybeAddImport("javax.persistence.Transient");
                return (J.VariableDeclarations)JavaTemplate.builder((String)"@Transient").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"javax.persistence-api-2.2"})).imports(new String[]{"javax.persistence.Transient"}).build().apply(this.getCursor(), multiVariable.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
            }
        };
    }

    @Generated
    public AddTransientAnnotationToEntity() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddTransientAnnotationToEntity(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTransientAnnotationToEntity)) {
            return false;
        }
        AddTransientAnnotationToEntity other = (AddTransientAnnotationToEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddTransientAnnotationToEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    static class EntityAccumulator {
        private final Set<JavaType> entityClasses = new HashSet<JavaType>();

        EntityAccumulator() {
        }

        public void addEntity(JavaType type) {
            this.entityClasses.add(type);
        }

        public boolean isEntity(JavaType type) {
            return this.entityClasses.contains(type);
        }
    }
}

