/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class NoGuavaListsNewCopyOnWriteArrayList
extends Recipe {
    private static final MethodMatcher NEW_ARRAY_LIST = new MethodMatcher("com.google.common.collect.Lists newCopyOnWriteArrayList()");
    private static final MethodMatcher NEW_ARRAY_LIST_ITERABLE = new MethodMatcher("com.google.common.collect.Lists newCopyOnWriteArrayList(java.lang.Iterable)");
    final String displayName = "Prefer `new CopyOnWriteArrayList<>()`";
    final String description = "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    final Set<String> tags = Collections.singleton("guava");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(NEW_ARRAY_LIST), new UsesMethod(NEW_ARRAY_LIST_ITERABLE)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_ARRAY_LIST.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.concurrent.CopyOnWriteArrayList");
                    return JavaTemplate.builder((String)"new CopyOnWriteArrayList<>()").contextSensitive().imports(new String[]{"java.util.concurrent.CopyOnWriteArrayList"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[0]);
                }
                if (NEW_ARRAY_LIST_ITERABLE.matches((MethodCall)method) && method.getArguments().size() == 1 && TypeUtils.isAssignableTo((String)"java.util.Collection", (JavaType)((Expression)method.getArguments().get(0)).getType())) {
                    this.maybeRemoveImport("com.google.common.collect.Lists");
                    this.maybeAddImport("java.util.concurrent.CopyOnWriteArrayList");
                    return JavaTemplate.builder((String)"new CopyOnWriteArrayList<>(#{any(java.util.Collection)})").contextSensitive().imports(new String[]{"java.util.concurrent.CopyOnWriteArrayList"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

