/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.search;

import io.micrometer.core.instrument.util.StringUtils;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.migrate.table.JavaVersionPerSourceSet;
import org.openrewrite.java.migrate.table.JavaVersionRow;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;

public final class AboutJavaVersion
extends Recipe {
    private final transient JavaVersionPerSourceSet javaVersionPerSourceSet = new JavaVersionPerSourceSet(this);
    @Option(required=false, description="Only mark the Java version when this type is in use.", example="lombok.val")
    @Nullable
    private final String whenUsesType;

    public String getDisplayName() {
        return "Find which Java version is in use";
    }

    public String getDescription() {
        return "A diagnostic for studying the distribution of Java language version levels (both source and target compatibility across files and source sets).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final HashSet seenSourceSets = new HashSet();
        TreeVisitor<Tree, ExecutionContext> visitor = new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree cu, ExecutionContext ctx) {
                if (!(cu instanceof JavaSourceFile)) {
                    return cu;
                }
                return cu.getMarkers().findFirst(JavaVersion.class).map(version -> {
                    String sourceSet;
                    String projectName = cu.getMarkers().findFirst(JavaProject.class).map(JavaProject::getProjectName).orElse("");
                    if (seenSourceSets.add(new ProjectSourceSet(projectName, sourceSet = cu.getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getName).orElse("")))) {
                        AboutJavaVersion.this.javaVersionPerSourceSet.insertRow(ctx, new JavaVersionRow(projectName, sourceSet, version.getCreatedBy(), version.getVmVendor(), version.getSourceCompatibility(), Integer.toString(version.getMajorReleaseVersion()), version.getTargetCompatibility()));
                    }
                    return SearchResult.found((Tree)cu, (String)("Java version: " + version.getMajorVersion()));
                }).orElse(cu);
            }
        };
        if (StringUtils.isNotBlank((String)this.whenUsesType)) {
            visitor = Preconditions.check((TreeVisitor)new UsesType(this.whenUsesType, Boolean.valueOf(false)), (TreeVisitor)visitor);
        }
        return visitor;
    }

    @ConstructorProperties(value={"whenUsesType"})
    public AboutJavaVersion(@Nullable String whenUsesType) {
        this.whenUsesType = whenUsesType;
    }

    public JavaVersionPerSourceSet getJavaVersionPerSourceSet() {
        return this.javaVersionPerSourceSet;
    }

    @Nullable
    public String getWhenUsesType() {
        return this.whenUsesType;
    }

    @NonNull
    public String toString() {
        return "AboutJavaVersion(javaVersionPerSourceSet=" + (Object)((Object)this.getJavaVersionPerSourceSet()) + ", whenUsesType=" + this.getWhenUsesType() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AboutJavaVersion)) {
            return false;
        }
        AboutJavaVersion other = (AboutJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$whenUsesType = this.getWhenUsesType();
        String other$whenUsesType = other.getWhenUsesType();
        return !(this$whenUsesType == null ? other$whenUsesType != null : !this$whenUsesType.equals(other$whenUsesType));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AboutJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $whenUsesType = this.getWhenUsesType();
        result = result * 59 + ($whenUsesType == null ? 43 : $whenUsesType.hashCode());
        return result;
    }

    static final class ProjectSourceSet {
        private final String javaProject;
        private final String javaSourceSet;

        @ConstructorProperties(value={"javaProject", "javaSourceSet"})
        public ProjectSourceSet(String javaProject, String javaSourceSet) {
            this.javaProject = javaProject;
            this.javaSourceSet = javaSourceSet;
        }

        public String getJavaProject() {
            return this.javaProject;
        }

        public String getJavaSourceSet() {
            return this.javaSourceSet;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectSourceSet)) {
                return false;
            }
            ProjectSourceSet other = (ProjectSourceSet)o;
            String this$javaProject = this.getJavaProject();
            String other$javaProject = other.getJavaProject();
            if (this$javaProject == null ? other$javaProject != null : !this$javaProject.equals(other$javaProject)) {
                return false;
            }
            String this$javaSourceSet = this.getJavaSourceSet();
            String other$javaSourceSet = other.getJavaSourceSet();
            return !(this$javaSourceSet == null ? other$javaSourceSet != null : !this$javaSourceSet.equals(other$javaSourceSet));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $javaProject = this.getJavaProject();
            result = result * 59 + ($javaProject == null ? 43 : $javaProject.hashCode());
            String $javaSourceSet = this.getJavaSourceSet();
            result = result * 59 + ($javaSourceSet == null ? 43 : $javaSourceSet.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "AboutJavaVersion.ProjectSourceSet(javaProject=" + this.getJavaProject() + ", javaSourceSet=" + this.getJavaSourceSet() + ")";
        }
    }
}

