/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.util.Map;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.ChangeTagAttribute;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class BeansXmlNamespace
extends Recipe {
    private static final XPathMatcher BEANS_MATCHER = new XPathMatcher("/beans");
    private static final String NS_SUN = "http://java.sun.com/xml/ns/javaee";
    private static final String NS_JCP = "http://xmlns.jcp.org/xml/ns/javaee";
    private static final String SUN_SCHEMA_LOCATION = "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/beans_1_0.xsd";
    private static final String JCP_SCHEMA_LOCATION = "http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/beans_1_1.xsd";

    public String getDisplayName() {
        return "Change `beans.xml` `schemaLocation` to match XML namespace";
    }

    public String getDescription() {
        return "Set the `schemaLocation` that corresponds to the `xmlns` set in `beans.xml` files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles("**/beans.xml"), (TreeVisitor)new XmlVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (BEANS_MATCHER.matches(this.getCursor())) {
                    Map<String, String> attributes = t.getAttributes().stream().collect(Collectors.toMap(Xml.Attribute::getKeyAsString, Xml.Attribute::getValueAsString));
                    String xmlns = attributes.get("xmlns");
                    String schemaLocation = attributes.get("xsi:schemaLocation");
                    if (BeansXmlNamespace.NS_SUN.equalsIgnoreCase(xmlns) && !BeansXmlNamespace.SUN_SCHEMA_LOCATION.equalsIgnoreCase(schemaLocation)) {
                        this.doAfterVisit(new ChangeTagAttribute("beans", "xsi:schemaLocation", BeansXmlNamespace.SUN_SCHEMA_LOCATION, null).getVisitor());
                    } else if (BeansXmlNamespace.NS_JCP.equalsIgnoreCase(xmlns) && !BeansXmlNamespace.JCP_SCHEMA_LOCATION.equalsIgnoreCase(schemaLocation)) {
                        this.doAfterVisit(new ChangeTagAttribute("beans", "xsi:schemaLocation", BeansXmlNamespace.JCP_SCHEMA_LOCATION, null).getVisitor());
                    }
                }
                return t;
            }
        });
    }

    @NonNull
    public String toString() {
        return "BeansXmlNamespace()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeansXmlNamespace)) {
            return false;
        }
        BeansXmlNamespace other = (BeansXmlNamespace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof BeansXmlNamespace;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

