/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class ReplaceStringLiteralValue
extends Recipe {
    @Option(displayName="Old literal `String` value", description="The `String` value to replace.", example="apple")
    private final @NonNull String oldLiteralValue;
    @Option(displayName="New literal `String` value", description="The `String` value to replace with.", example="orange")
    private final @NonNull String newLiteralValue;

    @JsonCreator
    public ReplaceStringLiteralValue(@JsonProperty(value="oldStringValue") @NonNull String oldStringValue, @JsonProperty(value="newStringValue") @NonNull String newStringValue) {
        this.oldLiteralValue = oldStringValue;
        this.newLiteralValue = newStringValue;
    }

    public String getDisplayName() {
        return "Replace `String` literal";
    }

    public String getDescription() {
        return "Replace the value of a complete `String` literal.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                J.Literal l = super.visitLiteral(literal, (Object)ctx);
                if (l.getType() != JavaType.Primitive.String || !ReplaceStringLiteralValue.this.oldLiteralValue.equals(literal.getValue())) {
                    return l;
                }
                return literal.withValue((Object)ReplaceStringLiteralValue.this.newLiteralValue).withValueSource('\"' + ReplaceStringLiteralValue.this.newLiteralValue + '\"');
            }
        };
    }

    @Generated
    public @NonNull String getOldLiteralValue() {
        return this.oldLiteralValue;
    }

    @Generated
    public @NonNull String getNewLiteralValue() {
        return this.newLiteralValue;
    }

    @org.openrewrite.internal.lang.NonNull
    @Generated
    public String toString() {
        return "ReplaceStringLiteralValue(oldLiteralValue=" + this.getOldLiteralValue() + ", newLiteralValue=" + this.getNewLiteralValue() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceStringLiteralValue)) {
            return false;
        }
        ReplaceStringLiteralValue other = (ReplaceStringLiteralValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldLiteralValue = this.getOldLiteralValue();
        String other$oldLiteralValue = other.getOldLiteralValue();
        if (this$oldLiteralValue == null ? other$oldLiteralValue != null : !this$oldLiteralValue.equals(other$oldLiteralValue)) {
            return false;
        }
        String this$newLiteralValue = this.getNewLiteralValue();
        String other$newLiteralValue = other.getNewLiteralValue();
        return !(this$newLiteralValue == null ? other$newLiteralValue != null : !this$newLiteralValue.equals(other$newLiteralValue));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceStringLiteralValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldLiteralValue = this.getOldLiteralValue();
        result = result * 59 + ($oldLiteralValue == null ? 43 : $oldLiteralValue.hashCode());
        String $newLiteralValue = this.getNewLiteralValue();
        result = result * 59 + ($newLiteralValue == null ? 43 : $newLiteralValue.hashCode());
        return result;
    }
}

