/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.maven;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class UpdateMavenProjectPropertyJavaVersion
extends Recipe {
    private static final List<String> JAVA_VERSION_XPATHS = Arrays.asList("/project/properties/java.version", "/project/properties/jdk.version", "/project/properties/javaVersion", "/project/properties/jdkVersion", "/project/properties/maven.compiler.source", "/project/properties/maven.compiler.target", "/project/properties/maven.compiler.release", "/project/properties/release.version");
    private static final List<XPathMatcher> JAVA_VERSION_XPATH_MATCHERS = JAVA_VERSION_XPATHS.stream().map(XPathMatcher::new).collect(Collectors.toList());
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;

    public String getDisplayName() {
        return "Update Maven Java project properties";
    }

    public String getDescription() {
        return "The Java version is determined by several project properties, including:\n\n * `java.version`\n * `jdk.version`\n * `javaVersion`\n * `jdkVersion`\n * `maven.compiler.source`\n * `maven.compiler.target`\n * `maven.compiler.release`\n * `release.version`\n\n These project properties are not added if they are not currently set, but only updated in place.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                tag = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (JAVA_VERSION_XPATH_MATCHERS.stream().anyMatch(matcher -> matcher.matches(this.getCursor()))) {
                    Optional maybeVersion = tag.getValue().flatMap(value -> {
                        try {
                            return Optional.of(Float.valueOf(Float.parseFloat(value)));
                        }
                        catch (NumberFormatException e) {
                            return Optional.empty();
                        }
                    });
                    if (!maybeVersion.isPresent()) {
                        return tag;
                    }
                    float currentVersion = ((Float)maybeVersion.get()).floatValue();
                    if (currentVersion >= (float)UpdateMavenProjectPropertyJavaVersion.this.version.intValue()) {
                        return tag;
                    }
                    return tag.withValue(String.valueOf(UpdateMavenProjectPropertyJavaVersion.this.version));
                }
                return tag;
            }
        };
    }

    @ConstructorProperties(value={"version"})
    public UpdateMavenProjectPropertyJavaVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "UpdateMavenProjectPropertyJavaVersion(version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateMavenProjectPropertyJavaVersion)) {
            return false;
        }
        UpdateMavenProjectPropertyJavaVersion other = (UpdateMavenProjectPropertyJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateMavenProjectPropertyJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }
}

