/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.UpdateJavaCompatibility;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.migrate.maven.UpdateMavenProjectPropertyJavaVersion;
import org.openrewrite.java.migrate.maven.UseMavenCompilerPluginReleaseConfiguration;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;

public final class UpgradeJavaVersion
extends Recipe {
    @Option(displayName="Java version", description="The Java version to upgrade to.", example="11")
    private final Integer version;

    public String getDisplayName() {
        return "Upgrade Java version";
    }

    public String getDescription() {
        return "Upgrade build plugin configuration to use the specified Java version. This recipe changes `java.toolchain.languageVersion` in `build.gradle(.kts)` of gradle projects, or maven-compiler-plugin target version and related settings. Will not downgrade if the version is newer than the specified version.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new UseMavenCompilerPluginReleaseConfiguration(this.version), new UpdateMavenProjectPropertyJavaVersion(this.version), new UpdateJavaCompatibility(this.version, null, null, Boolean.valueOf(false), null)});
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(0L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String newVersion = this.version.toString();
        final HashMap updatedMarkers = new HashMap();
        return new JavaIsoVisitor<ExecutionContext>(){

            public J preVisit(J tree, ExecutionContext ctx) {
                Optional maybeJavaVersion = tree.getMarkers().findFirst(JavaVersion.class);
                if (maybeJavaVersion.isPresent() && ((JavaVersion)maybeJavaVersion.get()).getMajorVersion() < UpgradeJavaVersion.this.version) {
                    return (J)tree.withMarkers(tree.getMarkers().setByType((Marker)updatedMarkers.computeIfAbsent((JavaVersion)maybeJavaVersion.get(), m -> m.withSourceCompatibility(newVersion).withTargetCompatibility(newVersion))));
                }
                return tree;
            }
        };
    }

    @ConstructorProperties(value={"version"})
    public UpgradeJavaVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    @NonNull
    public String toString() {
        return "UpgradeJavaVersion(version=" + this.getVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeJavaVersion)) {
            return false;
        }
        UpgradeJavaVersion other = (UpgradeJavaVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeJavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        return result;
    }
}

