/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.javax;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.javax.AnnotateTypesVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class AddScopeToInjectedClass
extends ScanningRecipe<Set<String>> {
    private static final String JAVAX_INJECT_INJECT = "javax.inject.Inject";
    private static final String JAVAX_ENTERPRISE_CONTEXT_DEPENDENT = "javax.enterprise.context.Dependent";
    private static final Collection<String> TYPES_PROMPTING_SCOPE_ADDITION = Arrays.asList("javax.inject.Inject");

    public String getDisplayName() {
        return "Add scope annotation to injected classes";
    }

    public String getDescription() {
        return "Finds member variables annotated with `@Inject' and applies `@Dependent` scope annotation to the variable's type.";
    }

    public Set<String> getInitialValue(ExecutionContext ctx) {
        return new HashSet<String>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Set<String> injectedTypes) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)executionContext);
                for (JavaType.Variable variable : cd.getType().getMembers()) {
                    if (!this.variableTypeRequiresScope(variable)) continue;
                    injectedTypes.add(((JavaType.FullyQualified)variable.getType()).getFullyQualifiedName());
                }
                return cd;
            }

            private boolean variableTypeRequiresScope(@Nullable JavaType.Variable memberVariable) {
                if (memberVariable == null) {
                    return false;
                }
                AnnotationMatcher matcher = new AnnotationMatcher(AddScopeToInjectedClass.JAVAX_INJECT_INJECT);
                for (JavaType.FullyQualified fullYQualifiedAnnotation : memberVariable.getAnnotations()) {
                    if (!memberVariable.getAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)matcher).matchesAnnotationOrMetaAnnotation(arg_0))) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Set<String> injectedTypes) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit compilationUnit, ExecutionContext executionContext) {
                J.CompilationUnit cu = super.visitCompilationUnit(compilationUnit, (Object)executionContext);
                for (J.ClassDeclaration aClass : cu.getClasses()) {
                    if (!injectedTypes.contains(aClass.getType().getFullyQualifiedName())) continue;
                    return new AnnotateTypesVisitor(AddScopeToInjectedClass.JAVAX_ENTERPRISE_CONTEXT_DEPENDENT).visitCompilationUnit(cu, injectedTypes);
                }
                return cu;
            }
        };
    }
}

