/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;

public class OptionalNotPresentToIsEmpty
extends Recipe {
    private static final String JAVA_UTIL_OPTIONAL_IS_PRESENT = "java.util.Optional isPresent()";

    public String getDisplayName() {
        return "Prefer `Optional.isEmpty()`";
    }

    public String getDescription() {
        return "Prefer `Optional.isEmpty()` instead of using `!Optional.isPresent()` in Java 11 or higher.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(11), new UsesMethod(JAVA_UTIL_OPTIONAL_IS_PRESENT)});
        final MethodMatcher optionalIsPresentMatcher = new MethodMatcher(JAVA_UTIL_OPTIONAL_IS_PRESENT);
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public Statement visitStatement(Statement s, ExecutionContext ctx) {
                J.MethodInvocation methodInvocation;
                Expression expression;
                J.Unary unary;
                Statement statement = (Statement)super.visitStatement(s, (Object)ctx);
                if (statement instanceof J.Unary && (unary = (J.Unary)statement).getOperator() == J.Unary.Type.Not && (expression = unary.getExpression()) instanceof J.MethodInvocation && optionalIsPresentMatcher.matches((MethodCall)(methodInvocation = (J.MethodInvocation)expression))) {
                    return (Statement)JavaTemplate.builder((String)"#{any()}.isEmpty()").contextSensitive().build().apply(this.getCursor(), statement.getCoordinates().replace(), new Object[]{methodInvocation.getSelect()});
                }
                return statement;
            }
        });
    }
}

