/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.micrometer.misk;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class NoExplicitEmptyLabelList
extends Recipe {
    final String displayName = "Don't use an explicit empty label list";
    final String description = "`listOf()` is the default argument for the `labels` parameter.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final List<JavaTemplate> hasEmptyLabel = Arrays.asList(JavaTemplate.builder((String)"#{m:any(misk.metrics.v2.Metrics)}.counter(#{s:any(java.lang.String)}, #{s1:any(java.lang.String)}, listOf())").staticImports(new String[]{"kotlin.collections.CollectionsKt.listOf"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build(), JavaTemplate.builder((String)"#{m:any(misk.metrics.v2.Metrics)}.gauge(#{s:any(java.lang.String)}, #{s1:any(java.lang.String)}, listOf())").staticImports(new String[]{"kotlin.collections.CollectionsKt.listOf"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build(), JavaTemplate.builder((String)"#{m:any(misk.metrics.v2.Metrics)}.peakGauge(#{s:any(java.lang.String)}, #{s1:any(java.lang.String)}, listOf())").staticImports(new String[]{"kotlin.collections.CollectionsKt.listOf"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build());

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (method.getSelect() != null && TypeUtils.isOfClassType((JavaType)method.getSelect().getType(), (String)"misk.metrics.v2.Metrics") && this.hasEmptyLabel.stream().anyMatch(tmpl -> tmpl.matches(this.getCursor()))) {
                    JavaType.Method methodType = method.getMethodType();
                    if (methodType != null) {
                        methodType = methodType.withParameterNames(Collections.emptyList()).withParameterTypes(Collections.emptyList());
                    }
                    return method.withArguments(ListUtils.map((List)method.getArguments(), (i, a) -> i == 2 ? null : a)).withMethodType(methodType).withName(method.getName().withType((JavaType)methodType));
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

