/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.micrometer;

import java.util.ArrayList;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class TimerToObservation
extends Recipe {
    private static final String TIMER = "io.micrometer.core.instrument.Timer";
    private static final String OBSERVATION = "io.micrometer.observation.Observation";
    final String displayName = "Convert Micrometer `Timer` to `Observations`";
    final String description = "Convert Micrometer `Timer` to `Observations` to instrument once, and get multiple benefits out of it.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("io.micrometer.core.instrument.Timer record*(..)", false), new UsesMethod("io.micrometer.core.instrument.Timer wrap(..)", false)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{Preconditions.not((TreeVisitor)new UsesMethod("io.micrometer.core.instrument.Timer record(java.time.Duration)", false)), Preconditions.not((TreeVisitor)new UsesMethod("io.micrometer.core.instrument.Timer record(long, java.util.concurrent.TimeUnit)", false))})}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final ChangeType changeTypeRegistry = new ChangeType("io.micrometer.core.instrument.MeterRegistry", "io.micrometer.observation.ObservationRegistry", null);
            private final ChangeType changeTypeTimer = new ChangeType("io.micrometer.core.instrument.Timer", "io.micrometer.observation.Observation", null);
            private final ChangeMethodName changeRecord = new ChangeMethodName("io.micrometer.observation.Observation record*(..)", "observe", null, null);
            private final MethodMatcher builderMatcher = new MethodMatcher("io.micrometer.observation.Observation builder(String)");
            private final MethodMatcher registerMatcher = new MethodMatcher("io.micrometer.observation.Observation$Builder register(io.micrometer.observation.ObservationRegistry)");
            private final MethodMatcher tagMatcher = new MethodMatcher("io.micrometer.observation.Observation$Builder tag(String, String)");
            private final MethodMatcher tagsMatcher = new MethodMatcher("io.micrometer.observation.Observation$Builder tags(..)");
            private final MethodMatcher tagsIterableMatcher = new MethodMatcher("io.micrometer.observation.Observation$Builder tags(java.lang.Iterable)");

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit compilationUnit, ExecutionContext ctx) {
                J.CompilationUnit cu = compilationUnit;
                cu = (J.CompilationUnit)this.changeTypeRegistry.getVisitor().visitNonNull((Tree)cu, (Object)ctx);
                cu = (J.CompilationUnit)this.changeTypeTimer.getVisitor().visitNonNull((Tree)cu, (Object)ctx);
                cu = (J.CompilationUnit)this.changeRecord.getVisitor().visitNonNull((Tree)cu, (Object)ctx);
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
                if (this.registerMatcher.matches((MethodCall)mi)) {
                    Expression timerName = null;
                    Expression registry = (Expression)mi.getArguments().get(0);
                    ArrayList<String> builder = new ArrayList<String>();
                    ArrayList<Expression> parameters = new ArrayList<Expression>();
                    Expression maybeBuilder = mi.getSelect();
                    while (maybeBuilder instanceof J.MethodInvocation) {
                        J.MethodInvocation builderMethod = (J.MethodInvocation)maybeBuilder;
                        if (this.builderMatcher.matches(maybeBuilder)) {
                            timerName = (Expression)builderMethod.getArguments().get(0);
                        } else if (this.tagMatcher.matches(maybeBuilder)) {
                            builder.add("\n.highCardinalityKeyValue(#{any(String)}, #{any(String)})");
                            parameters.add((Expression)builderMethod.getArguments().get(0));
                            parameters.add((Expression)builderMethod.getArguments().get(1));
                        } else if (this.tagsIterableMatcher.matches(maybeBuilder)) {
                            builder.add("\n.highCardinalityKeyValues(KeyValues.of(#{any(java.lang.Iterable)}, Tag::getKey, Tag::getValue))");
                            parameters.addAll(builderMethod.getArguments());
                            this.maybeAddImport("io.micrometer.common.KeyValues");
                            this.maybeAddImport("io.micrometer.core.instrument.Tag");
                        } else if (this.tagsMatcher.matches(maybeBuilder)) {
                            String args = StringUtils.repeat((String)"#{any(String)},", (int)builderMethod.getArguments().size());
                            args = args.substring(0, args.length() - 1);
                            builder.add("\n.highCardinalityKeyValues(KeyValues.of(" + args + "))");
                            parameters.addAll(builderMethod.getArguments());
                            this.maybeAddImport("io.micrometer.common.KeyValues");
                        }
                        maybeBuilder = ((J.MethodInvocation)maybeBuilder).getSelect();
                    }
                    if (timerName != null) {
                        parameters.add(0, timerName);
                        parameters.add(1, registry);
                        this.maybeRemoveImport(TimerToObservation.TIMER);
                        this.maybeAddImport(TimerToObservation.OBSERVATION);
                        JavaTemplate template = JavaTemplate.builder((String)("Observation.createNotStarted(#{any(java.lang.String)}, #{any()})" + String.join((CharSequence)"", builder))).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"micrometer-observation", "micrometer-commons", "micrometer-core"})).imports(new String[]{TimerToObservation.OBSERVATION}).imports(new String[]{"io.micrometer.common.KeyValues"}).imports(new String[]{"io.micrometer.core.instrument.Tag"}).build();
                        mi = (J.MethodInvocation)this.autoFormat((J)((J.MethodInvocation)template.apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), parameters.toArray())), ctx);
                    }
                }
                return super.visitMethodInvocation(mi, (Object)ctx);
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

