/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.slf4j.CompleteExceptionLogging;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class Slf4jLogShouldBeConstant
extends Recipe {
    private static final String SLF4J_FORMAT_SPECIFIER = "{}";
    private static final Pattern SLF4J_FORMAT_SPECIFIER_PATTERN = Pattern.compile("\\{}");
    private static final Pattern FORMAT_SPECIFIER_PATTERN = Pattern.compile("%[-#+ 0,(\\d+]*[\\d.]*[dfscbBhHn%]");
    private static final Pattern SIMPLE_FORMAT_SPECIFIER_PATTERN = Pattern.compile("%[dfscbBhHn%]");
    private static final Pattern INDEXED_FORMAT_SPECIFIER_PATTERN = Pattern.compile("%(\\d+\\$)[a-zA-Z]");
    private static final MethodMatcher SLF4J_LOG = new MethodMatcher("org.slf4j.Logger *(..)");
    private static final MethodMatcher STRING_FORMAT = new MethodMatcher("java.lang.String format(..)");
    private static final MethodMatcher STRING_VALUE_OF = new MethodMatcher("java.lang.String valueOf(..)");
    private static final MethodMatcher OBJECT_TO_STRING = new MethodMatcher("java.lang.Object toString()");
    final String displayName = "SLF4J logging statements should begin with constants";
    final String description = "Logging statements shouldn't begin with `String#format`, calls to `toString()`, etc.";
    final Set<String> tags = new HashSet<String>(Arrays.asList("logging", "slf4j"));

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(SLF4J_LOG), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                String name;
                if (SLF4J_LOG.matches((MethodCall)method) && ("trace".equals(name = method.getSimpleName()) || "debug".equals(name) || "info".equals(name) || "warn".equals(name) || "error".equals(name))) {
                    Expression toString;
                    List args = method.getArguments();
                    if (STRING_FORMAT.matches((Expression)args.get(0))) {
                        J.MethodInvocation stringFormat = (J.MethodInvocation)args.get(0);
                        if (!CompleteExceptionLogging.isStringLiteral((Expression)stringFormat.getArguments().get(0))) {
                            return method;
                        }
                        String strFormat = Objects.requireNonNull(((J.Literal)stringFormat.getArguments().get(0)).getValue()).toString();
                        if (Slf4jLogShouldBeConstant.containsIndexFormatSpecifier(strFormat) || Slf4jLogShouldBeConstant.this.containsCombinedFormatSpecifiers(strFormat) || Slf4jLogShouldBeConstant.containsComplexFormatSpecifiers(strFormat)) {
                            return method;
                        }
                        String updatedStrFormat = Slf4jLogShouldBeConstant.replaceFormatSpecifier(strFormat, Slf4jLogShouldBeConstant.SLF4J_FORMAT_SPECIFIER);
                        List stringFormatWithArgs = ListUtils.map((List)stringFormat.getArguments(), (n, arg) -> {
                            if (n == 0) {
                                J.Literal str = (J.Literal)arg;
                                return str.withValue((Object)updatedStrFormat).withValueSource("\"" + updatedStrFormat + "\"");
                            }
                            return arg;
                        });
                        List originalArgsWithoutMessage = args.subList(1, args.size());
                        return method.withArguments(ListUtils.concatAll((List)stringFormatWithArgs, originalArgsWithoutMessage));
                    }
                    if (STRING_VALUE_OF.matches((Expression)args.get(0))) {
                        Expression valueOf = (Expression)((J.MethodInvocation)args.get(0)).getArguments().get(0);
                        if (TypeUtils.isAssignableTo((JavaType)JavaType.ShallowClass.build((String)"java.lang.Throwable"), (JavaType)valueOf.getType())) {
                            J.MethodInvocation m = (J.MethodInvocation)JavaTemplate.builder((String)"\"Exception\", #{any()}").contextSensitive().build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{valueOf});
                            return m.withSelect(method.getSelect());
                        }
                    } else if (OBJECT_TO_STRING.matches((Expression)args.get(0)) && (toString = ((J.MethodInvocation)args.get(0)).getSelect()) != null) {
                        J.MethodInvocation m = (J.MethodInvocation)JavaTemplate.builder((String)"\"{}\", #{any()}").contextSensitive().build().apply(this.getCursor(), method.getCoordinates().replaceArguments(), new Object[]{toString});
                        return m.withSelect(method.getSelect());
                    }
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }

    private boolean containsCombinedFormatSpecifiers(String str) {
        return FORMAT_SPECIFIER_PATTERN.matcher(str).find() && SLF4J_FORMAT_SPECIFIER_PATTERN.matcher(str).find();
    }

    private static String replaceFormatSpecifier(String str, String replacement) {
        if (StringUtils.isNullOrEmpty((String)str)) {
            return str;
        }
        return FORMAT_SPECIFIER_PATTERN.matcher(str).replaceAll(replacement);
    }

    private static boolean containsIndexFormatSpecifier(String str) {
        if (StringUtils.isNullOrEmpty((String)str)) {
            return false;
        }
        return INDEXED_FORMAT_SPECIFIER_PATTERN.matcher(str).find();
    }

    private static boolean containsComplexFormatSpecifiers(String str) {
        if (StringUtils.isNullOrEmpty((String)str)) {
            return false;
        }
        Matcher matcher = FORMAT_SPECIFIER_PATTERN.matcher(str);
        while (matcher.find()) {
            String specifier = matcher.group();
            if (SIMPLE_FORMAT_SPECIFIER_PATTERN.matcher(specifier).matches()) continue;
            return true;
        }
        return false;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

