/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;

public class MatchIsLogLevelEnabledWithLogStatements
extends Recipe {
    private static final MethodMatcher ENABLED_MATCHER = new MethodMatcher("org.slf4j.Logger is*Enabled()");
    private static final MethodMatcher LOG_MATCHER = new MethodMatcher("org.slf4j.Logger *(..)");
    final String displayName = "Match `if (is*Enabled())` with logging statements";
    final String description = "Change any `if (is*Enabled())` statements that do not match the maximum log level used in the `then` part to use the matching `is*Enabled()` method for that log level. This ensures that the logging condition is consistent with the actual logging statements.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ENABLED_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.If visitIf(J.If iff, ExecutionContext ctx) {
                LogLevel maxUsedLogLevel;
                J.MethodInvocation mi;
                LogLevel conditionLogLevel;
                J.If if_ = super.visitIf(iff, (Object)ctx);
                if (if_.getIfCondition().getTree() instanceof J.MethodInvocation && if_.getElsePart() == null && (conditionLogLevel = LogLevel.extractEnabledLogLevel(mi = (J.MethodInvocation)if_.getIfCondition().getTree())) != null && (maxUsedLogLevel = this.findMaxUsedLogLevel(if_.getThenPart())) != null && conditionLogLevel != maxUsedLogLevel) {
                    return if_.withIfCondition(if_.getIfCondition().withTree((J)maxUsedLogLevel.toEnabledInvocation(mi)));
                }
                return if_;
            }

            private @Nullable LogLevel findMaxUsedLogLevel(Statement statement) {
                return (LogLevel)((Object)((AtomicReference)new JavaIsoVisitor<AtomicReference<LogLevel>>(){

                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, AtomicReference<@Nullable LogLevel> reference) {
                        J.MethodInvocation mi = super.visitMethodInvocation(method, reference);
                        reference.accumulateAndGet(LogLevel.extractUsedLogLevel(mi), BinaryOperator.maxBy(Comparator.nullsFirst(Comparator.comparing(Enum::ordinal))));
                        return mi;
                    }

                    public J.Try.Catch visitCatch(J.Try.Catch catch_, AtomicReference<@Nullable LogLevel> logLevelAtomicReference) {
                        return catch_;
                    }

                    public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, AtomicReference<@Nullable LogLevel> logLevelAtomicReference) {
                        return multiCatch;
                    }
                }.reduce((Tree)statement, new AtomicReference<Object>(null))).get());
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    private static enum LogLevel {
        trace,
        debug,
        info,
        warn,
        error;


        public static @Nullable LogLevel extractEnabledLogLevel(J.MethodInvocation methodInvocation) {
            if (ENABLED_MATCHER.matches((MethodCall)methodInvocation)) {
                String methodName = methodInvocation.getSimpleName();
                String logLevel = methodName.substring(2, methodName.length() - 7);
                for (LogLevel level : LogLevel.values()) {
                    if (!level.name().equalsIgnoreCase(logLevel)) continue;
                    return level;
                }
            }
            return null;
        }

        public static @Nullable LogLevel extractUsedLogLevel(J.MethodInvocation methodInvocation) {
            if (LOG_MATCHER.matches((MethodCall)methodInvocation)) {
                for (LogLevel level : LogLevel.values()) {
                    if (!level.name().equals(methodInvocation.getSimpleName())) continue;
                    return level;
                }
            }
            return null;
        }

        public J.MethodInvocation toEnabledInvocation(J.MethodInvocation methodInvocation) {
            String enabledMethodName = String.format("is%s%sEnabled", this.name().substring(0, 1).toUpperCase(), this.name().substring(1));
            JavaType.Method type = Objects.requireNonNull(methodInvocation.getMethodType()).withName(enabledMethodName);
            return methodInvocation.withName(methodInvocation.getName().withSimpleName(enabledMethodName).withType((JavaType)type)).withMethodType(type);
        }
    }
}

