/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.ArgumentArrayToVarargs;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JulParameterizedArguments
extends Recipe {
    private static final MethodMatcher METHOD_MATCHER_PARAM = new MethodMatcher("java.util.logging.Logger log(java.util.logging.Level, java.lang.String, java.lang.Object)");
    private static final MethodMatcher METHOD_MATCHER_ARRAY = new MethodMatcher("java.util.logging.Logger log(java.util.logging.Level, java.lang.String, java.lang.Object[])");
    final String displayName = "Replace parameterized JUL level call with corresponding SLF4J method calls";
    final String description = "Replace calls to parameterized `Logger.log(Level,String,\u2026)` call with the corresponding slf4j method calls transforming the formatter and parameter lists.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(METHOD_MATCHER_PARAM), new UsesMethod(METHOD_MATCHER_ARRAY)}), (TreeVisitor)new JulParameterizedToSlf4jVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    private static class JulParameterizedToSlf4jVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private JulParameterizedToSlf4jVisitor() {
        }

        public static boolean isStringLiteral(Expression expression) {
            return expression instanceof J.Literal && TypeUtils.isString((JavaType)((J.Literal)expression).getType());
        }

        private static String escapeForJavaStringLiteral(String s) {
            return s.replace("\\", "\\\\").replace("\"", "\\\"");
        }

        private static @Nullable String getMethodIdentifier(Expression levelArgument) {
            String levelSimpleName;
            switch (levelSimpleName = levelArgument instanceof J.FieldAccess ? ((J.FieldAccess)levelArgument).getName().getSimpleName() : ((J.Identifier)levelArgument).getSimpleName()) {
                case "ALL": 
                case "FINEST": 
                case "FINER": {
                    return "trace";
                }
                case "FINE": {
                    return "debug";
                }
                case "CONFIG": 
                case "INFO": {
                    return "info";
                }
                case "WARNING": {
                    return "warn";
                }
                case "SEVERE": {
                    return "error";
                }
            }
            return null;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (METHOD_MATCHER_ARRAY.matches((MethodCall)method) || METHOD_MATCHER_PARAM.matches((MethodCall)method)) {
                List originalArguments = method.getArguments();
                Expression levelArgument = (Expression)originalArguments.get(0);
                Expression messageArgument = (Expression)originalArguments.get(1);
                Expression stringFormatArgument = (Expression)originalArguments.get(2);
                if (stringFormatArgument.getType() instanceof JavaType.Array && !(stringFormatArgument instanceof J.NewArray)) {
                    return method;
                }
                if (!(levelArgument instanceof J.FieldAccess) && !(levelArgument instanceof J.Identifier) || !JulParameterizedToSlf4jVisitor.isStringLiteral(messageArgument)) {
                    return method;
                }
                String newName = JulParameterizedToSlf4jVisitor.getMethodIdentifier(levelArgument);
                if (newName == null) {
                    return method;
                }
                this.maybeRemoveImport("java.util.logging.Level");
                String originalFormatString = Objects.requireNonNull((String)((J.Literal)messageArgument).getValue());
                List<Integer> originalIndices = this.originalLoggedArgumentIndices(originalFormatString);
                Expression updatedStringFormatArgument = stringFormatArgument;
                if (stringFormatArgument instanceof J.NewArray) {
                    J.NewArray newArray = (J.NewArray)stringFormatArgument;
                    List arrayContent = newArray.getInitializer() == null ? Collections.emptyList() : newArray.getInitializer();
                    updatedStringFormatArgument = newArray.withInitializer(originalIndices.stream().map(arrayContent::get).collect(Collectors.toList())).withType((JavaType)((JavaType.Array)Objects.requireNonNull(newArray.getType())).withElemType((JavaType)JavaType.ShallowClass.build((String)"java.lang.Object")));
                }
                String slf4jFormatString = JulParameterizedToSlf4jVisitor.escapeForJavaStringLiteral(originalFormatString.replaceAll("\\{\\d*}", "{}"));
                J.MethodInvocation updatedMi = (J.MethodInvocation)JavaTemplate.builder((String)(newName + "(\"#{}\",#{anyArray(Object)})")).build().apply(this.getCursor(), method.getCoordinates().replaceMethod(), new Object[]{slf4jFormatString, updatedStringFormatArgument});
                if (!(stringFormatArgument instanceof J.NewArray) && originalIndices.size() > 1) {
                    return updatedMi.withArguments(ListUtils.concatAll((List)updatedMi.getArguments(), Collections.nCopies(originalIndices.size() - 1, updatedStringFormatArgument)));
                }
                this.doAfterVisit(new ArgumentArrayToVarargs().getVisitor());
                HashSet<Flag> flags = new HashSet<Flag>(Objects.requireNonNull(updatedMi.getMethodType()).getFlags());
                flags.add(Flag.Varargs);
                return updatedMi.withMethodType(updatedMi.getMethodType().withFlags(flags));
            }
            return super.visitMethodInvocation(method, (Object)ctx);
        }

        private List<Integer> originalLoggedArgumentIndices(String strFormat) {
            Matcher matcher = Pattern.compile("\\{(\\d+)}").matcher(strFormat);
            ArrayList<Integer> loggedArgumentIndices = new ArrayList<Integer>(2);
            while (matcher.find()) {
                loggedArgumentIndices.add(Integer.valueOf(matcher.group(1)));
            }
            return loggedArgumentIndices;
        }
    }
}

