/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class ChangeLogLevel
extends Recipe {
    private final String displayName = "Change SLF4J log level";
    private final String description = "Change the log level of SLF4J log statements.";
    @Option(displayName="From", description="The log level to change from.", example="INFO")
    private final Level from;
    @Option(displayName="To", description="The log level to change to.", example="DEBUG")
    private final Level to;
    @Option(displayName="Starts with", description="Only change log statements that start with this string. When omitted all log statements of the specified level are changed.", example="LaunchDarkly", required=false)
    private final @Nullable String startsWith;

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String methodPattern = "org.slf4j.Logger " + this.from.name().toLowerCase() + "(..)";
        return Preconditions.check((TreeVisitor)new UsesMethod(methodPattern), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final MethodMatcher logMatcher;
            {
                this.logMatcher = new MethodMatcher(methodPattern);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (!this.logMatcher.matches((MethodCall)m)) {
                    return m;
                }
                List args = m.getArguments();
                if (args.isEmpty()) {
                    return m;
                }
                J.Literal lit = ChangeLogLevel.this.leftMostLiteral((Expression)args.get(0));
                if (lit == null || lit.getValue() == null) {
                    return m;
                }
                if (!StringUtils.isBlank((String)ChangeLogLevel.this.startsWith) && !lit.getValue().toString().startsWith(ChangeLogLevel.this.startsWith)) {
                    return m;
                }
                return (J.MethodInvocation)new ChangeMethodName(methodPattern, ChangeLogLevel.this.to.name().toLowerCase(), Boolean.valueOf(true), null).getVisitor().visitNonNull((Tree)m, (Object)ctx);
            }
        });
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable J.Literal leftMostLiteral(Expression arg) {
        if (arg instanceof J.Literal) {
            return (J.Literal)arg;
        }
        if (arg instanceof J.Binary) {
            return this.leftMostLiteral(((J.Binary)arg).getLeft());
        }
        return null;
    }

    @ConstructorProperties(value={"from", "to", "startsWith"})
    @Generated
    public ChangeLogLevel(Level from, Level to, @Nullable String startsWith) {
        this.from = from;
        this.to = to;
        this.startsWith = startsWith;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Level getFrom() {
        return this.from;
    }

    @Generated
    public Level getTo() {
        return this.to;
    }

    @Generated
    public @Nullable String getStartsWith() {
        return this.startsWith;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeLogLevel(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", from=" + (Object)((Object)this.getFrom()) + ", to=" + (Object)((Object)this.getTo()) + ", startsWith=" + this.getStartsWith() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeLogLevel)) {
            return false;
        }
        ChangeLogLevel other = (ChangeLogLevel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Level this$from = this.getFrom();
        Level other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)((Object)this$from)).equals((Object)other$from)) {
            return false;
        }
        Level this$to = this.getTo();
        Level other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)((Object)this$to)).equals((Object)other$to)) {
            return false;
        }
        String this$startsWith = this.getStartsWith();
        String other$startsWith = other.getStartsWith();
        return !(this$startsWith == null ? other$startsWith != null : !this$startsWith.equals(other$startsWith));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeLogLevel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Level $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)((Object)$from)).hashCode());
        Level $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)((Object)$to)).hashCode());
        String $startsWith = this.getStartsWith();
        result = result * 59 + ($startsWith == null ? 43 : $startsWith.hashCode());
        return result;
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

