/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.log4j;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class ConvertJulEntering
extends Recipe {
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("java.util.logging.Logger entering(String, String, ..)", false);
    private final String displayName = "Rewrites JUL's Logger#entering method to Log4j API";
    private final String description = "Replaces JUL's Logger#entering method calls to Log4j API Logger#traceEntry calls.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(METHOD_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (METHOD_MATCHER.matches((MethodCall)m)) {
                    List originalArgs = m.getArguments();
                    int originalArgCount = originalArgs.size();
                    if (3 < originalArgCount) {
                        return m;
                    }
                    ArrayList<Object> modifiedArgs = new ArrayList<Object>();
                    ArrayList<Object> modifiedTypes = new ArrayList<Object>();
                    if (2 < originalArgCount) {
                        modifiedArgs.add(this.buildNullString());
                        modifiedTypes.add(JavaType.Primitive.String);
                        modifiedArgs.add((Expression)originalArgs.get(2));
                        modifiedTypes.add(JavaType.buildType((String)"java.lang.Object[]"));
                    }
                    JavaType.Method mt = m.getMethodType().withParameterTypes(modifiedTypes).withDeclaringType(m.getMethodType().getDeclaringType().withFullyQualifiedName("org.apache.logging.log4j.Logger"));
                    return m.withMethodType(mt).withName(m.getName().withSimpleName("traceEntry")).withArguments(modifiedArgs);
                }
                return m;
            }

            private J.Literal buildNullString() {
                return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, "null", null, JavaType.Primitive.String);
            }
        });
    }

    @Generated
    public ConvertJulEntering() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ConvertJulEntering(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertJulEntering)) {
            return false;
        }
        ConvertJulEntering other = (ConvertJulEntering)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ConvertJulEntering;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

