/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.jboss;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class LoggerLevelArgumentToMethod
extends Recipe {
    private static final MethodMatcher LOG_MATCHER = new MethodMatcher("org.jboss.logging.Logger log(*,*,..)", true);
    private static final MethodMatcher LOGF_MATCHER = new MethodMatcher("org.jboss.logging.Logger logf(*,*,..)", true);
    private static final MethodMatcher LOGV_MATCHER = new MethodMatcher("org.jboss.logging.Logger logv(*,*,..)", true);
    final String displayName = "Replace JBoss Logging Level arguments with the corresponding eponymous level method calls";
    final String description = "Replace calls to `Logger.log(Level, ...)` with the corresponding eponymous level method calls. For example `Logger.log(Level.INFO, ...)` to `Logger.info(...)`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.jboss.logging.Logger", Boolean.valueOf(true)), new UsesType("org.jboss.logging.Logger.Level", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(LOG_MATCHER), new UsesMethod(LOGF_MATCHER), new UsesMethod(LOGV_MATCHER)})});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
                List updatedArguments;
                String logLevelName;
                J.MethodInvocation m = super.visitMethodInvocation(mi, (Object)ctx);
                if (!(LOG_MATCHER.matches((MethodCall)m) || LOGF_MATCHER.matches((MethodCall)m) || LOGV_MATCHER.matches((MethodCall)m))) {
                    return m;
                }
                List args = m.getArguments();
                Expression firstArgument = (Expression)args.get(0);
                Expression secondArgument = (Expression)args.get(1);
                if (TypeUtils.isAssignableTo((String)"org.jboss.logging.Logger.Level", (JavaType)firstArgument.getType())) {
                    String suffix = "";
                    if (LOGF_MATCHER.matches((MethodCall)m)) {
                        suffix = "f";
                    } else if (LOGV_MATCHER.matches((MethodCall)m)) {
                        suffix = "v";
                    }
                    logLevelName = this.extractLogLevelName(firstArgument);
                    if (logLevelName != null) {
                        logLevelName = logLevelName + suffix;
                    }
                    updatedArguments = ListUtils.concat((Object)((Expression)secondArgument.withPrefix(secondArgument.getPrefix().withWhitespace(firstArgument.getPrefix().getWhitespace()))), args.subList(2, args.size()));
                } else if (TypeUtils.isAssignableTo((String)"java.lang.String", (JavaType)firstArgument.getType()) && TypeUtils.isAssignableTo((String)"org.jboss.logging.Logger.Level", (JavaType)secondArgument.getType()) && LOG_MATCHER.matches((MethodCall)m)) {
                    logLevelName = this.extractLogLevelName(secondArgument);
                    updatedArguments = ListUtils.filter((List)args, it -> it != secondArgument);
                } else {
                    return m;
                }
                if (logLevelName == null) {
                    return m;
                }
                JavaType.Method updatedMethodType = Objects.requireNonNull(m.getMethodType()).withParameterTypes(ListUtils.filter((List)m.getMethodType().getParameterTypes(), it -> !TypeUtils.isAssignableTo((String)"org.jboss.logging.Logger.Level", (JavaType)it))).withParameterNames(ListUtils.filter((List)m.getMethodType().getParameterNames(), it -> !"level".equals(it))).withName(logLevelName.toLowerCase());
                return m.withArguments(updatedArguments).withMethodType(updatedMethodType).withName(m.getName().withSimpleName(logLevelName.toLowerCase()));
            }

            @Nullable String extractLogLevelName(Expression expression) {
                if (expression instanceof J.Identifier) {
                    J.Identifier identifier = (J.Identifier)expression;
                    if (identifier.getFieldType() != null && identifier.getFieldType().getOwner() instanceof JavaType.Class) {
                        return identifier.getSimpleName();
                    }
                } else if (expression instanceof J.FieldAccess) {
                    return ((J.FieldAccess)expression).getSimpleName();
                }
                return null;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

