/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.AddLogger;
import org.openrewrite.java.logging.LoggingFramework;
import org.openrewrite.java.search.FindFieldsOfType;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class PrintStackTraceToLogError
extends Recipe {
    @Option(displayName="Add logger", description="Add a logger field to the class if it isn't already present.", required=false)
    private final @Nullable Boolean addLogger;
    @Option(displayName="Logger name", description="The name of the logger to use when generating a field.", required=false, example="log")
    private final @Nullable String loggerName;
    @Option(displayName="Logging framework", description="The logging framework to use.", valid={"SLF4J", "Log4J1", "Log4J2", "JUL", "COMMONS", "SYSTEM"}, required=false)
    private final @Nullable String loggingFramework;
    private final String displayName = "Use logger instead of `printStackTrace()`";
    private final String description = "When a logger is present, log exceptions rather than calling `printStackTrace()`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher printStackTrace = new MethodMatcher("java.lang.Throwable printStackTrace(..)");
        final LoggingFramework framework = LoggingFramework.fromOption(this.loggingFramework);
        final AnnotationMatcher lombokLogAnnotationMatcher = new AnnotationMatcher("@lombok.extern..*");
        JavaIsoVisitor<ExecutionContext> visitor = new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (printStackTrace.matches((MethodCall)m)) {
                    Cursor classCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
                    AnnotationService annotationService = (AnnotationService)this.service(AnnotationService.class);
                    Set loggers = FindFieldsOfType.find((J)((J)classCursor.getValue()), (String)framework.getLoggerType());
                    if (!loggers.isEmpty()) {
                        J.Identifier logField = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)loggers.iterator().next()).getVariables().get(0)).getName();
                        m = this.replaceMethodInvocation(m, logField, ctx);
                    } else if (annotationService.matches(classCursor, lombokLogAnnotationMatcher)) {
                        String fieldName = PrintStackTraceToLogError.this.loggerName == null ? "log" : PrintStackTraceToLogError.this.loggerName;
                        J.Identifier logField = new J.Identifier(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, Collections.emptyList(), fieldName, null, null);
                        m = this.replaceMethodInvocation(m, logField, ctx);
                    } else if (PrintStackTraceToLogError.this.addLogger != null && PrintStackTraceToLogError.this.addLogger.booleanValue()) {
                        this.doAfterVisit(AddLogger.addLogger((J.ClassDeclaration)classCursor.getValue(), framework, PrintStackTraceToLogError.this.loggerName == null ? "logger" : PrintStackTraceToLogError.this.loggerName, ctx));
                    }
                }
                return m;
            }

            private J.MethodInvocation replaceMethodInvocation(J.MethodInvocation m, J.Identifier logField, ExecutionContext ctx) {
                if (framework == LoggingFramework.JUL) {
                    this.maybeAddImport("java.util.logging.Level");
                }
                if (framework == LoggingFramework.SYSTEM) {
                    this.maybeAddImport("java.lang.System.Logger.Level");
                }
                return (J.MethodInvocation)framework.getErrorTemplate("\"Exception\"", ctx).apply(new Cursor(this.getCursor().getParent(), (Object)m), m.getCoordinates().replace(), new Object[]{logField, m.getSelect()});
            }
        };
        return Repeat.repeatUntilStable((TreeVisitor)(this.addLogger != null && this.addLogger != false ? visitor : Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(framework.getLoggerType(), null), new UsesType("lombok.extern..*", null)}), (TreeVisitor)visitor)));
    }

    @ConstructorProperties(value={"addLogger", "loggerName", "loggingFramework"})
    @Generated
    public PrintStackTraceToLogError(@Nullable Boolean addLogger, @Nullable String loggerName, @Nullable String loggingFramework) {
        this.addLogger = addLogger;
        this.loggerName = loggerName;
        this.loggingFramework = loggingFramework;
    }

    @Generated
    public @Nullable Boolean getAddLogger() {
        return this.addLogger;
    }

    @Generated
    public @Nullable String getLoggerName() {
        return this.loggerName;
    }

    @Generated
    public @Nullable String getLoggingFramework() {
        return this.loggingFramework;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "PrintStackTraceToLogError(addLogger=" + this.getAddLogger() + ", loggerName=" + this.getLoggerName() + ", loggingFramework=" + this.getLoggingFramework() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrintStackTraceToLogError)) {
            return false;
        }
        PrintStackTraceToLogError other = (PrintStackTraceToLogError)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addLogger = this.getAddLogger();
        Boolean other$addLogger = other.getAddLogger();
        if (this$addLogger == null ? other$addLogger != null : !((Object)this$addLogger).equals(other$addLogger)) {
            return false;
        }
        String this$loggerName = this.getLoggerName();
        String other$loggerName = other.getLoggerName();
        if (this$loggerName == null ? other$loggerName != null : !this$loggerName.equals(other$loggerName)) {
            return false;
        }
        String this$loggingFramework = this.getLoggingFramework();
        String other$loggingFramework = other.getLoggingFramework();
        if (this$loggingFramework == null ? other$loggingFramework != null : !this$loggingFramework.equals(other$loggingFramework)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof PrintStackTraceToLogError;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addLogger = this.getAddLogger();
        result = result * 59 + ($addLogger == null ? 43 : ((Object)$addLogger).hashCode());
        String $loggerName = this.getLoggerName();
        result = result * 59 + ($loggerName == null ? 43 : $loggerName.hashCode());
        String $loggingFramework = this.getLoggingFramework();
        result = result * 59 + ($loggingFramework == null ? 43 : $loggingFramework.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

