/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.logging.LoggingFramework;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class ChangeLoggersToPrivate
extends Recipe {
    private static final Set<String> LOGGER_TYPES = Arrays.stream(LoggingFramework.values()).map(LoggingFramework::getLoggerType).collect(Collectors.toSet());
    private final String displayName = "Change logger fields to `private`";
    private final String description = "Ensures that logger fields are declared as `private` to encapsulate logging mechanics within the class.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(ChangeLoggersToPrivate.usesAnyLogger(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations mv = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (mv.getTypeExpression() == null || !this.isLoggerType(mv.getTypeExpression().getType()) || mv.hasModifier(J.Modifier.Type.Private)) {
                    return mv;
                }
                Cursor parent = this.getCursor().getParentTreeCursor();
                if (!(parent.getValue() instanceof J.Block)) {
                    return mv;
                }
                if (!((parent = parent.getParentTreeCursor()).getValue() instanceof J.ClassDeclaration)) {
                    return mv;
                }
                J.ClassDeclaration classDeclaration = (J.ClassDeclaration)parent.getValue();
                if (classDeclaration.getKind() == J.ClassDeclaration.Kind.Type.Interface || classDeclaration.hasModifier(J.Modifier.Type.Abstract)) {
                    return mv;
                }
                List mapped = ListUtils.map((List)mv.getModifiers(), mod -> {
                    if (mod.getType() == J.Modifier.Type.Public || mod.getType() == J.Modifier.Type.Protected || mod.getType() == J.Modifier.Type.Private) {
                        return mod.withType(J.Modifier.Type.Private);
                    }
                    return mod;
                });
                if (mapped == mv.getModifiers()) {
                    mapped = ListUtils.insert((List)mapped, (Object)new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, J.Modifier.Type.Private, Collections.emptyList()), (int)0);
                }
                return (J.VariableDeclarations)this.autoFormat((J)mv.withModifiers(mapped), (J)mv.getTypeExpression(), ctx, this.getCursor().getParentTreeCursor());
            }

            private boolean isLoggerType(@Nullable JavaType type) {
                JavaType.FullyQualified fqnType = TypeUtils.asFullyQualified((JavaType)type);
                if (fqnType != null) {
                    return LOGGER_TYPES.contains(fqnType.getFullyQualifiedName());
                }
                return false;
            }
        });
    }

    private static TreeVisitor<?, ExecutionContext> usesAnyLogger() {
        UsesType[] usesTypes = new UsesType[LOGGER_TYPES.size()];
        int i = 0;
        for (String fqn : LOGGER_TYPES) {
            usesTypes[i++] = new UsesType(fqn, Boolean.valueOf(true));
        }
        return Preconditions.or((TreeVisitor[])usesTypes);
    }

    @Generated
    public ChangeLoggersToPrivate() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeLoggersToPrivate(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeLoggersToPrivate)) {
            return false;
        }
        ChangeLoggersToPrivate other = (ChangeLoggersToPrivate)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeLoggersToPrivate;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

