/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import org.openrewrite.java.template.RecipeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RecipeDescriptor(name="Replace JUL Logger creation with SLF4J LoggerFactory", description="Replace calls to `Logger.getLogger` with `LoggerFactory.getLogger`.")
public class JulGetLoggerToLoggerFactory {

    @RecipeDescriptor(name="Replace JUL `Logger.getLogger(Some.class.getCanonicalName())` with SLF4J's `LoggerFactory.getLogger(Some.class)`", description="Replace calls to `java.util.logging.Logger.getLogger(Some.class.getCanonicalName())` with `org.slf4j.LoggerFactory.getLogger(Some.class)`.")
    public static class GetLoggerClassCanonicalNameToLoggerFactory {
        java.util.logging.Logger before(Class<?> clazz) {
            return java.util.logging.Logger.getLogger(clazz.getCanonicalName());
        }

        Logger after(Class<?> clazz) {
            return LoggerFactory.getLogger(clazz);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.getLogger(Some.class.getName())` with SLF4J's `LoggerFactory.getLogger(Some.class)`", description="Replace calls to `java.util.logging.Logger.getLogger(Some.class.getName())` with `org.slf4j.LoggerFactory.getLogger(Some.class)`.")
    public static class GetLoggerClassNameToLoggerFactory {
        java.util.logging.Logger before(Class<?> clazz) {
            return java.util.logging.Logger.getLogger(clazz.getName());
        }

        Logger after(Class<?> clazz) {
            return LoggerFactory.getLogger(clazz);
        }
    }
}

