/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins.github;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.jenkins.github.ArtifactIdTeamNameGenerator;
import org.openrewrite.jenkins.github.InMemoryTeamNameValidator;
import org.openrewrite.jenkins.github.TeamNameGenerator;
import org.openrewrite.jenkins.github.TeamNameInput;
import org.openrewrite.jenkins.github.TeamNameValidator;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.text.PlainTextVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class AddTeamToCodeowners
extends ScanningRecipe<Scanned> {
    private static final String FILE_PATH = ".github/CODEOWNERS";
    private final String displayName = "Add plugin developer team to CODEOWNERS";
    private final String description = "Adds the `{artifactId}-plugin-developers` team to all files in `.github/CODEOWNERS` if absent.";

    public Scanned getInitialValue(ExecutionContext ctx) {
        return new Scanned(new ArtifactIdTeamNameGenerator(), new InMemoryTeamNameValidator());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Scanned acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx, Cursor parent) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                Path path = sourceFile.getSourcePath();
                String fileName = path.getFileName().toString();
                if ("CODEOWNERS".equals(fileName)) {
                    acc.foundFile = true;
                } else if (acc.artifactId == null && "pom.xml".equals(fileName)) {
                    Xml.Document pom = (Xml.Document)sourceFile;
                    ArtifactIdExtractor extractor = new ArtifactIdExtractor();
                    extractor.visit((Tree)pom, ctx);
                    acc.artifactId = extractor.artifactId;
                }
                return sourceFile;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Scanned acc, ExecutionContext ctx) {
        if (acc.foundFile || !acc.hasValidTeamName()) {
            return Collections.emptyList();
        }
        PlainTextParser parser = new PlainTextParser();
        String line = "* " + acc.teamName() + "\n";
        return parser.parse(new String[]{line}).map(brandNewFile -> (PlainText)brandNewFile.withSourcePath(Paths.get(FILE_PATH, new String[0]))).collect(Collectors.toList());
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Scanned acc) {
        return Preconditions.check((boolean)acc.hasValidTeamName(), (TreeVisitor)new PlainTextVisitor<ExecutionContext>(){

            public PlainText visitText(PlainText plainText, ExecutionContext ctx) {
                if (!Paths.get(AddTeamToCodeowners.FILE_PATH, new String[0]).equals(plainText.getSourcePath())) {
                    return plainText;
                }
                String text = plainText.getText();
                if (acc.presentIn(text)) {
                    return plainText;
                }
                boolean endsWithNewLine = text.endsWith("\n");
                LinkedList<String> lines = new LinkedList<String>();
                LinkedList<String> after = new LinkedList<String>();
                try (Scanner scanner = new Scanner(text);){
                    int atPos = 0;
                    boolean lastComment = true;
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        if (atPos == 0 && line.contains("@")) {
                            atPos = line.indexOf("@");
                        }
                        if (lastComment && line.startsWith("#")) {
                            lines.add(line);
                            continue;
                        }
                        lastComment = false;
                        after.add(line);
                    }
                    int spaces = Math.max(1, atPos - 1);
                    lines.add("*" + StringUtils.repeat((String)" ", (int)spaces) + acc.teamName());
                    lines.addAll(after);
                    String updated = String.join((CharSequence)"\n", lines);
                    if (endsWithNewLine) {
                        updated = updated + "\n";
                    }
                    PlainText plainText2 = plainText.withText(updated);
                    return plainText2;
                }
            }
        });
    }

    @Generated
    public AddTeamToCodeowners() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddTeamToCodeowners(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddTeamToCodeowners)) {
            return false;
        }
        AddTeamToCodeowners other = (AddTeamToCodeowners)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddTeamToCodeowners;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static class Scanned {
        private final TeamNameGenerator<TeamNameInput> generator;
        private final TeamNameValidator validator;
        String artifactId;
        boolean foundFile;

        public Scanned(TeamNameGenerator<TeamNameInput> generator, TeamNameValidator validator) {
            this.generator = generator;
            this.validator = validator;
        }

        boolean presentIn(String text) {
            Pattern p = Pattern.compile("^\\*\\s+" + this.teamName() + "\\s*$");
            try (Scanner s = new Scanner(text);){
                while (s.hasNextLine()) {
                    String line = s.nextLine();
                    Matcher matcher = p.matcher(line);
                    if (!matcher.matches()) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }

        String teamName() {
            return this.generator.generate(new TeamNameInput(this.artifactId));
        }

        boolean hasValidTeamName() {
            return this.artifactId != null && this.validator.isValid(this.teamName());
        }

        @Generated
        public TeamNameGenerator<TeamNameInput> getGenerator() {
            return this.generator;
        }

        @Generated
        public TeamNameValidator getValidator() {
            return this.validator;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public boolean isFoundFile() {
            return this.foundFile;
        }

        @Generated
        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        @Generated
        public void setFoundFile(boolean foundFile) {
            this.foundFile = foundFile;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Scanned)) {
                return false;
            }
            Scanned other = (Scanned)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isFoundFile() != other.isFoundFile()) {
                return false;
            }
            TeamNameGenerator<TeamNameInput> this$generator = this.getGenerator();
            TeamNameGenerator<TeamNameInput> other$generator = other.getGenerator();
            if (this$generator == null ? other$generator != null : !this$generator.equals(other$generator)) {
                return false;
            }
            TeamNameValidator this$validator = this.getValidator();
            TeamNameValidator other$validator = other.getValidator();
            if (this$validator == null ? other$validator != null : !this$validator.equals(other$validator)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Scanned;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isFoundFile() ? 79 : 97);
            TeamNameGenerator<TeamNameInput> $generator = this.getGenerator();
            result = result * 59 + ($generator == null ? 43 : $generator.hashCode());
            TeamNameValidator $validator = this.getValidator();
            result = result * 59 + ($validator == null ? 43 : $validator.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddTeamToCodeowners.Scanned(generator=" + this.getGenerator() + ", validator=" + this.getValidator() + ", artifactId=" + this.getArtifactId() + ", foundFile=" + this.isFoundFile() + ")";
        }
    }

    private static class ArtifactIdExtractor
    extends MavenIsoVisitor<ExecutionContext> {
        private String artifactId = "";
        private static final XPathMatcher PROJECT_ARTIFACTID_MATCHER = new XPathMatcher("/project/artifactId");

        private ArtifactIdExtractor() {
        }

        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag t = super.visitTag(tag, (Object)ctx);
            if (PROJECT_ARTIFACTID_MATCHER.matches(this.getCursor())) {
                this.artifactId = (String)t.getValue().orElseThrow(() -> new IllegalStateException("Expected to find an artifact id"));
            }
            return t;
        }
    }
}

