/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public final class JenkinsfileAsGroovy
extends Recipe {
    @Option(displayName="File pattern", description="A glob pattern to match Jenkinsfile paths. Defaults to `**/Jenkinsfile*`.", example="**/Jenkinsfile*", required=false)
    private final @Nullable String filePattern;
    private final String displayName = "Parse `Jenkinsfile` as Groovy";
    private final String description = "Parse any `Jenkinsfile` as Groovy code.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        String paths = Optional.ofNullable(this.filePattern).orElse("**/Jenkinsfile*");
        return Preconditions.check((Recipe)new FindSourceFiles(paths), (TreeVisitor)new PlainTextVisitor<ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof PlainText) {
                    PlainText pt = (PlainText)tree;
                    return (Tree)GroovyParser.builder().build().parse(new String[]{pt.getText()}).findFirst().map(sourceFile -> ((SourceFile)((SourceFile)sourceFile.withId(pt.getId())).withMarkers(pt.getMarkers())).withSourcePath(pt.getSourcePath())).map(sf -> (SourceFile)SearchResult.found((Tree)sf, (String)"Parsed as Groovy")).orElse((SourceFile)pt);
                }
                return super.visit(tree, (Object)ctx);
            }
        });
    }

    @ConstructorProperties(value={"filePattern"})
    @Generated
    public JenkinsfileAsGroovy(@Nullable String filePattern) {
        this.filePattern = filePattern;
    }

    @Generated
    public @Nullable String getFilePattern() {
        return this.filePattern;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "JenkinsfileAsGroovy(filePattern=" + this.getFilePattern() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JenkinsfileAsGroovy)) {
            return false;
        }
        JenkinsfileAsGroovy other = (JenkinsfileAsGroovy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        if (this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof JenkinsfileAsGroovy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

