/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.jenkins.Jenkins;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.xml.tree.Xml;

public class CreateIndexJelly
extends ScanningRecipe<Scanned> {
    final String displayName = "Create `index.jelly` if it doesn't exist";
    final String description = "Jenkins tooling [requires](https://github.com/jenkinsci/maven-hpi-plugin/pull/302) `src/main/resources/index.jelly` exists with a description.";

    public Scanned getInitialValue(ExecutionContext ctx) {
        return new Scanned();
    }

    public Collection<PlainText> generate(Scanned acc, ExecutionContext ctx) {
        LinkedList<PlainText> generated = new LinkedList<PlainText>();
        PlainTextParser parser = new PlainTextParser();
        for (DescribedPlugin plugin : acc.plugins) {
            if (acc.indexJellies.contains(plugin.indexJellyPath)) continue;
            parser.parse(new String[]{plugin.contents()}).map(brandNewFile -> (PlainText)brandNewFile.withSourcePath(Paths.get(plugin.indexJellyPath, new String[0]))).forEach(generated::add);
        }
        return generated;
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Scanned acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                Path path = sourceFile.getSourcePath();
                String fileName = path.getFileName().toString();
                if ("index.jelly".equals(fileName)) {
                    acc.indexJellies.add(path.toString());
                } else if (Jenkins.isJenkinsPluginPom(sourceFile) != null) {
                    Xml.Document pom = (Xml.Document)sourceFile;
                    TagExtractor tags = new TagExtractor();
                    tags.visit((Tree)pom, ctx);
                    acc.plugins.add(new DescribedPlugin(tags.artifactId, path.resolve("../src/main/resources/index.jelly").normalize().toString(), tags.description));
                }
                return sourceFile;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    static class Scanned {
        Set<String> indexJellies = new HashSet<String>();
        Set<DescribedPlugin> plugins = new HashSet<DescribedPlugin>();

        Scanned() {
        }
    }

    private static final class DescribedPlugin {
        private final String artifactId;
        private final String indexJellyPath;
        private final String pomDescription;

        String contents() {
            String desc = this.pomDescription.isEmpty() ? this.artifactId : this.pomDescription;
            return "<?jelly escape-by-default='true'?>\n<div>\n" + desc + "\n</div>\n";
        }

        @ConstructorProperties(value={"artifactId", "indexJellyPath", "pomDescription"})
        @Generated
        public DescribedPlugin(String artifactId, String indexJellyPath, String pomDescription) {
            this.artifactId = artifactId;
            this.indexJellyPath = indexJellyPath;
            this.pomDescription = pomDescription;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getIndexJellyPath() {
            return this.indexJellyPath;
        }

        @Generated
        public String getPomDescription() {
            return this.pomDescription;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DescribedPlugin)) {
                return false;
            }
            DescribedPlugin other = (DescribedPlugin)o;
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$indexJellyPath = this.getIndexJellyPath();
            String other$indexJellyPath = other.getIndexJellyPath();
            if (this$indexJellyPath == null ? other$indexJellyPath != null : !this$indexJellyPath.equals(other$indexJellyPath)) {
                return false;
            }
            String this$pomDescription = this.getPomDescription();
            String other$pomDescription = other.getPomDescription();
            return !(this$pomDescription == null ? other$pomDescription != null : !this$pomDescription.equals(other$pomDescription));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $indexJellyPath = this.getIndexJellyPath();
            result = result * 59 + ($indexJellyPath == null ? 43 : $indexJellyPath.hashCode());
            String $pomDescription = this.getPomDescription();
            result = result * 59 + ($pomDescription == null ? 43 : $pomDescription.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "CreateIndexJelly.DescribedPlugin(artifactId=" + this.getArtifactId() + ", indexJellyPath=" + this.getIndexJellyPath() + ", pomDescription=" + this.getPomDescription() + ")";
        }
    }

    private static class TagExtractor
    extends MavenIsoVisitor<ExecutionContext> {
        private String artifactId = "";
        private String description = "";

        private TagExtractor() {
        }

        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            Xml.Tag t = super.visitTag(tag, (Object)ctx);
            if ("description".equals(t.getName())) {
                this.description = t.getValue().orElse("");
            } else if ("artifactId".equals(t.getName()) && !this.isManagedDependencyTag() && !this.isDependencyTag()) {
                this.artifactId = (String)t.getValue().orElseThrow(() -> new IllegalStateException("Expected to find an artifact id"));
            }
            return t;
        }
    }
}

