/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jenkins.BomLookup;
import org.openrewrite.jenkins.Jenkins;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.AddManagedDependency;
import org.openrewrite.maven.ChangeManagedDependencyGroupIdAndArtifactId;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class AddPluginsBom
extends Recipe {
    private static final BomLookup LOOKUP = new BomLookup();
    private static final String PLUGINS_BOM_GROUP_ID = "io.jenkins.tools.bom";
    private static final String LATEST_RELEASE = "latest.release";
    private static final String VERSION_METADATA_PATTERN = "\\.v[a-f0-9_]+";
    private static final String PLUGIN_BOMS_KEY = "pluginBoms";
    private static final String PLUGIN_BOM_NAME_KEY = "pluginBomName";
    private final String displayName = "Add or correct Jenkins plugins BOM";
    private final String description = "Adds [Jenkins plugins BOM](https://www.jenkins.io/doc/developer/plugin-development/dependency-management/#jenkins-plugin-bom) at the latest release if the project depends on any managed versions or an outdated BOM is present. BOMs are expected to be synchronized to Jenkins LTS versions, so this will also remove any mismatched BOMs (Such as using Jenkins 2.387.3, but importing bom-2.319.x). If the expected BOM is already added, the version will not be upgraded.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Markers m = document.getMarkers();
                Optional maybeMavenResult = m.findFirst(MavenResolutionResult.class);
                if (!maybeMavenResult.isPresent()) {
                    return document;
                }
                if (Jenkins.isJenkinsPluginPom((SourceFile)document) == null) {
                    return document;
                }
                MavenResolutionResult result = (MavenResolutionResult)maybeMavenResult.get();
                ResolvedPom resolvedPom = result.getPom();
                Pom pom = resolvedPom.getRequested();
                List dependencyManagement = pom.getDependencyManagement();
                boolean bomFound = false;
                for (ManagedDependency md : dependencyManagement) {
                    if (!AddPluginsBom.PLUGINS_BOM_GROUP_ID.equals(md.getGroupId())) continue;
                    bomFound = true;
                    break;
                }
                boolean hasDependencyInBom = false;
                List dependencies = pom.getDependencies();
                for (Dependency dependency : dependencies) {
                    String groupId = dependency.getGroupId();
                    String version = dependency.getVersion();
                    if (groupId == null || version == null || !LOOKUP.inBom(groupId, dependency.getArtifactId())) continue;
                    hasDependencyInBom = true;
                    this.doAfterVisit(new RemoveRedundantDependencyVersions(groupId, dependency.getArtifactId(), (RemoveRedundantDependencyVersions.Comparator)null, null).getVisitor());
                }
                Xml.Document d = super.visitDocument(document, (Object)ctx);
                String bomName = (String)this.getCursor().getMessage(AddPluginsBom.PLUGIN_BOM_NAME_KEY);
                if (bomName == null) {
                    throw new IllegalStateException("Could not find jenkins.version property");
                }
                if (!bomFound && hasDependencyInBom) {
                    return (Xml.Document)new AddManagedDependency(AddPluginsBom.PLUGINS_BOM_GROUP_ID, bomName, AddPluginsBom.LATEST_RELEASE, "import", "pom", null, AddPluginsBom.VERSION_METADATA_PATTERN, Boolean.valueOf(true), null, null).getVisitor().visitNonNull((Tree)d, (Object)ctx, this.getCursor().getParentOrThrow());
                }
                if (bomFound) {
                    Xml.Tag exact = null;
                    Xml.Tag change = null;
                    List pluginBoms = (List)this.getCursor().getMessage(AddPluginsBom.PLUGIN_BOMS_KEY, Collections.emptyList());
                    for (Xml.Tag bom : pluginBoms) {
                        String artifactId = (String)bom.getChildValue("artifactId").orElseThrow(() -> new IllegalStateException("No artifactId found on bom"));
                        if (artifactId.equals(bomName) && exact == null) {
                            exact = bom;
                            continue;
                        }
                        if (change == null) {
                            change = bom;
                            continue;
                        }
                        this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)bom, true, true));
                    }
                    if (exact != null && change != null) {
                        this.doAfterVisit((TreeVisitor)new RemoveContentVisitor(change, true, true));
                    } else if (change != null) {
                        String artifactId = (String)change.getChildValue("artifactId").orElseThrow(() -> new IllegalStateException("No artifactId found on bom"));
                        this.doAfterVisit(new ChangeManagedDependencyGroupIdAndArtifactId(AddPluginsBom.PLUGINS_BOM_GROUP_ID, artifactId, AddPluginsBom.PLUGINS_BOM_GROUP_ID, bomName, AddPluginsBom.LATEST_RELEASE, AddPluginsBom.VERSION_METADATA_PATTERN).getVisitor());
                    }
                }
                return d;
            }

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, (Object)ctx);
                if (this.isManagedDependencyTag()) {
                    String groupId = tag.getChildValue("groupId").orElse("");
                    String artifactId = tag.getChildValue("artifactId").orElse("");
                    if ("bom-${jenkins.baseline}.x".equals(artifactId)) {
                        artifactId = "bom-" + (String)this.getResolutionResult().getPom().getProperties().get("jenkins.baseline") + ".x";
                    }
                    if (AddPluginsBom.PLUGINS_BOM_GROUP_ID.equals(groupId) && !artifactId.isEmpty()) {
                        List pluginBoms = (List)this.getCursor().getNearestMessage(AddPluginsBom.PLUGIN_BOMS_KEY, new LinkedList());
                        pluginBoms.add(t);
                        this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, AddPluginsBom.PLUGIN_BOMS_KEY, (Object)pluginBoms);
                    }
                } else if (this.isPropertyTag() && Objects.equals("jenkins.version", t.getName())) {
                    String jenkinsVersion = (String)t.getValue().orElseThrow(() -> new IllegalStateException("No value found for jenkins.version property tag"));
                    String bomName = Jenkins.bomNameForJenkinsVersion(jenkinsVersion);
                    this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, AddPluginsBom.PLUGIN_BOM_NAME_KEY, (Object)bomName);
                }
                return t;
            }
        };
    }

    @Generated
    public AddPluginsBom() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddPluginsBom(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPluginsBom)) {
            return false;
        }
        AddPluginsBom other = (AddPluginsBom)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddPluginsBom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

