/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp.dependencies;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.csharp.dependencies.trait.PackageReference;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class UpgradeDependencyVersion
extends Recipe {
    @Option(displayName="Package pattern", description="Package glob pattern used to match dependencies.", example="Microsoft*")
    private final String packagePattern;
    @Option(displayName="New version", description="An exact version number.", example="12.3")
    private final String newVersion;

    public String getDisplayName() {
        return "Upgrade C# dependency versions";
    }

    public String getDescription() {
        return "Upgrades dependencies in `*.csproj` and `packages.config`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PackageReference.Matcher().asVisitor((ref, ctx) -> {
            if (StringUtils.matchesGlob((String)ref.getInclude(), (String)this.packagePattern)) {
                return ref.withVersion(this.newVersion);
            }
            return ref.getTree();
        });
    }

    @ConstructorProperties(value={"packagePattern", "newVersion"})
    @Generated
    public UpgradeDependencyVersion(String packagePattern, String newVersion) {
        this.packagePattern = packagePattern;
        this.newVersion = newVersion;
    }

    @Generated
    public String getPackagePattern() {
        return this.packagePattern;
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeDependencyVersion(packagePattern=" + this.getPackagePattern() + ", newVersion=" + this.getNewVersion() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$packagePattern = this.getPackagePattern();
        String other$packagePattern = other.getPackagePattern();
        if (this$packagePattern == null ? other$packagePattern != null : !this$packagePattern.equals(other$packagePattern)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packagePattern = this.getPackagePattern();
        result = result * 59 + ($packagePattern == null ? 43 : $packagePattern.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        return result;
    }
}

