/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class Vulnerability {
    private final String cve;
    private final ZonedDateTime published;
    private final String summary;
    private final String groupArtifact;
    private final String introducedVersion;
    private final String fixedVersion;
    private final Severity severity;

    @ConstructorProperties(value={"cve", "published", "summary", "groupArtifact", "introducedVersion", "fixedVersion", "severity"})
    public Vulnerability(String cve, ZonedDateTime published, String summary, String groupArtifact, String introducedVersion, String fixedVersion, Severity severity) {
        this.cve = cve;
        this.published = published;
        this.summary = summary;
        this.groupArtifact = groupArtifact;
        this.introducedVersion = introducedVersion;
        this.fixedVersion = fixedVersion;
        this.severity = severity;
    }

    public String getCve() {
        return this.cve;
    }

    public ZonedDateTime getPublished() {
        return this.published;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getGroupArtifact() {
        return this.groupArtifact;
    }

    public String getIntroducedVersion() {
        return this.introducedVersion;
    }

    public String getFixedVersion() {
        return this.fixedVersion;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    @NonNull
    public String toString() {
        return "Vulnerability(cve=" + this.getCve() + ", published=" + this.getPublished() + ", summary=" + this.getSummary() + ", groupArtifact=" + this.getGroupArtifact() + ", introducedVersion=" + this.getIntroducedVersion() + ", fixedVersion=" + this.getFixedVersion() + ", severity=" + (Object)((Object)this.getSeverity()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability)o;
        String this$cve = this.getCve();
        String other$cve = other.getCve();
        return !(this$cve == null ? other$cve != null : !this$cve.equals(other$cve));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cve = this.getCve();
        result = result * 59 + ($cve == null ? 43 : $cve.hashCode());
        return result;
    }

    public static enum Severity {
        LOW,
        MODERATE,
        HIGH,
        CRITICAL;

    }
}

