/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson.codehaus;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class JsonIncludeAnnotation
extends Recipe {
    private static final String ORG_CODEHAUS_JACKSON_MAP_ANNOTATE_JSON_SERIALIZE = "org.codehaus.jackson.map.annotate.JsonSerialize";
    private static final String COM_FASTERXML_JACKSON_ANNOTATION_JSON_INCLUDE = "com.fasterxml.jackson.annotation.JsonInclude";
    final String displayName = "Migrate to Jackson `@JsonInclude`";
    final String description = "Move Codehaus' `@JsonSerialize.include` argument to FasterXMLs `@JsonInclude` annotation.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(ORG_CODEHAUS_JACKSON_MAP_ANNOTATE_JSON_SERIALIZE, Boolean.valueOf(false)), (TreeVisitor)new IntroduceJsonIncludeVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    private static class IntroduceJsonIncludeVisitor
    extends JavaVisitor<ExecutionContext> {
        private final AnnotationMatcher annotationMatcher = new AnnotationMatcher("@org.codehaus.jackson.map.annotate.JsonSerialize", Boolean.valueOf(false));

        private IntroduceJsonIncludeVisitor() {
        }

        public J visitClassDeclaration(J.ClassDeclaration decl, ExecutionContext ctx) {
            J.ClassDeclaration cd = (J.ClassDeclaration)super.visitClassDeclaration(decl, (Object)ctx);
            AtomicReference includeArgument = new AtomicReference();
            cd = cd.withLeadingAnnotations(ListUtils.map((List)cd.getLeadingAnnotations(), ann -> this.mapAnnotation((J.Annotation)ann, includeArgument)));
            if (includeArgument.get() != null) {
                cd = (J.ClassDeclaration)JavaTemplate.builder((String)("@JsonInclude(value = JsonInclude.Include." + (String)includeArgument.get() + ")")).imports(new String[]{JsonIncludeAnnotation.COM_FASTERXML_JACKSON_ANNOTATION_JSON_INCLUDE}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-annotations"})).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                this.maybeAddImport(JsonIncludeAnnotation.COM_FASTERXML_JACKSON_ANNOTATION_JSON_INCLUDE);
            }
            return cd;
        }

        public J visitMethodDeclaration(J.MethodDeclaration decl, ExecutionContext ctx) {
            J.MethodDeclaration md = (J.MethodDeclaration)super.visitMethodDeclaration(decl, (Object)ctx);
            AtomicReference includeArgument = new AtomicReference();
            md = md.withLeadingAnnotations(ListUtils.map((List)md.getLeadingAnnotations(), ann -> this.mapAnnotation((J.Annotation)ann, includeArgument)));
            if (includeArgument.get() != null) {
                md = (J.MethodDeclaration)JavaTemplate.builder((String)("@JsonInclude(value = JsonInclude.Include." + (String)includeArgument.get() + ")")).imports(new String[]{JsonIncludeAnnotation.COM_FASTERXML_JACKSON_ANNOTATION_JSON_INCLUDE}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-annotations"})).build().apply(this.updateCursor((Tree)md), md.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                this.maybeAddImport(JsonIncludeAnnotation.COM_FASTERXML_JACKSON_ANNOTATION_JSON_INCLUDE);
            }
            return md;
        }

        public J visitVariableDeclarations(J.VariableDeclarations decl, ExecutionContext ctx) {
            J.VariableDeclarations vd = (J.VariableDeclarations)super.visitVariableDeclarations(decl, (Object)ctx);
            AtomicReference includeArgument = new AtomicReference();
            vd = vd.withLeadingAnnotations(ListUtils.map((List)vd.getLeadingAnnotations(), ann -> this.mapAnnotation((J.Annotation)ann, includeArgument)));
            if (includeArgument.get() != null) {
                vd = (J.VariableDeclarations)JavaTemplate.builder((String)("@JsonInclude(value = JsonInclude.Include." + (String)includeArgument.get() + ")")).imports(new String[]{JsonIncludeAnnotation.COM_FASTERXML_JACKSON_ANNOTATION_JSON_INCLUDE}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-annotations"})).build().apply(this.updateCursor((Tree)vd), vd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                this.maybeAddImport(JsonIncludeAnnotation.COM_FASTERXML_JACKSON_ANNOTATION_JSON_INCLUDE);
            }
            return vd;
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Annotation mapAnnotation(J.Annotation ann, AtomicReference<String> includeArgument) {
            if (!this.annotationMatcher.matches(ann)) {
                this.maybeRemoveImport(JsonIncludeAnnotation.ORG_CODEHAUS_JACKSON_MAP_ANNOTATE_JSON_SERIALIZE);
                return ann;
            }
            if ((ann = ann.withArguments(ListUtils.map((List)ann.getArguments(), arg -> {
                J.Assignment assignment = (J.Assignment)arg;
                J.Identifier variable = (J.Identifier)assignment.getVariable();
                if (!"include".equals(variable.getSimpleName())) {
                    return arg;
                }
                Expression right = assignment.getAssignment();
                if (right instanceof J.FieldAccess) {
                    includeArgument.set(((J.FieldAccess)right).getName().getSimpleName());
                } else if (right instanceof J.Identifier) {
                    includeArgument.set(((J.Identifier)right).getSimpleName());
                }
                this.maybeRemoveImport("org.codehaus.jackson.map.annotate.JsonSerialize.Inclusion");
                this.maybeRemoveImport("org.codehaus.jackson.map.annotate.JsonSerialize.Inclusion." + (String)includeArgument.get());
                return null;
            }))).getArguments() == null || ann.getArguments().isEmpty()) {
                this.maybeRemoveImport(JsonIncludeAnnotation.ORG_CODEHAUS_JACKSON_MAP_ANNOTATE_JSON_SERIALIZE);
                return null;
            }
            return ann;
        }
    }
}

