/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson.codehaus;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.java.dependencies.AddDependency;
import org.openrewrite.java.dependencies.ChangeDependency;

public final class CodehausDependencyToFasterXML
extends Recipe {
    @Option(displayName="Codehaus Jackson version", description="The version of Codehaus Jackson to replace.", example="2.x", required=false)
    private final @Nullable String version;
    private final String displayName = "Migrate dependencies from Jackson Codehaus (legacy) to FasterXML";
    private final String description = "Replace Codehaus Jackson dependencies with FasterXML Jackson dependencies, and add databind if needed.";

    public List<Recipe> getRecipeList() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        String newVersion = this.version == null ? "2.x" : this.version;
        recipes.add((Recipe)new ChangeDependency("org.codehaus.jackson", "jackson-core-asl", "com.fasterxml.jackson.core", "jackson-core", newVersion, null, null, null));
        recipes.add((Recipe)new ChangeDependency("org.codehaus.jackson", "jackson-mapper-asl", "com.fasterxml.jackson.core", "jackson-databind", newVersion, null, null, null));
        recipes.add((Recipe)new AddDependency("com.fasterxml.jackson.core", "jackson-databind", newVersion, null, "com.fasterxml.jackson.databind.*", null, null, null, null, null, null, null, null, Boolean.valueOf(true)));
        return recipes;
    }

    @ConstructorProperties(value={"version"})
    @Generated
    public CodehausDependencyToFasterXML(@Nullable String version) {
        this.version = version;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "CodehausDependencyToFasterXML(version=" + this.getVersion() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodehausDependencyToFasterXML)) {
            return false;
        }
        CodehausDependencyToFasterXML other = (CodehausDependencyToFasterXML)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CodehausDependencyToFasterXML;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

