/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class UseModernDateTimeSerialization
extends Recipe {
    private static final String JACKSON_JSON_FORMAT = "com.fasterxml.jackson.annotation.JsonFormat";
    private static final AnnotationMatcher JSON_FORMAT_MATCHER = new AnnotationMatcher("@com.fasterxml.jackson.annotation.JsonFormat", Boolean.valueOf(true));
    private static final Set<String> JAVA_TIME_TYPES = new HashSet<String>(Arrays.asList("java.time.LocalDate", "java.time.LocalDateTime", "java.time.LocalTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime", "java.time.Instant"));
    private static final Set<String> ISO_8601_PATTERNS = new HashSet<String>(Arrays.asList("yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd", "HH:mm:ss"));
    final String displayName = "Use modern date/time serialization defaults";
    final String description = "Remove redundant `@JsonFormat` annotations on `java.time` types that specify ISO-8601 patterns, as Jackson 3 uses ISO-8601 as the default format (with `WRITE_DATES_AS_TIMESTAMPS` now disabled by default).";
    final Set<String> tags = Collections.singleton("jackson-3");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(JACKSON_JSON_FORMAT, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations vd = super.visitVariableDeclarations(multiVariable, (Object)ctx);
                if (vd.getType() == null || !this.isJavaTimeType(vd.getType())) {
                    return vd;
                }
                for (final J.Annotation annotation : vd.getLeadingAnnotations()) {
                    if (!JSON_FORMAT_MATCHER.matches(annotation) || !this.isRedundantIso8601Format(annotation)) continue;
                    this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(new AnnotationMatcher("@com.fasterxml.jackson.annotation.JsonFormat"){

                        public boolean matches(J.Annotation ann) {
                            return ann == annotation;
                        }
                    }));
                    this.maybeRemoveImport(UseModernDateTimeSerialization.JACKSON_JSON_FORMAT);
                }
                return vd;
            }

            private boolean isJavaTimeType(JavaType type) {
                if (type instanceof JavaType.FullyQualified) {
                    String fqn = ((JavaType.FullyQualified)type).getFullyQualifiedName();
                    return JAVA_TIME_TYPES.contains(fqn);
                }
                return false;
            }

            private boolean isRedundantIso8601Format(J.Annotation annotation) {
                J.Literal literal;
                J.Assignment assignment;
                List args = annotation.getArguments();
                if (args == null || args.size() != 1) {
                    return false;
                }
                Expression arg = (Expression)args.get(0);
                if (arg instanceof J.Assignment && (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && "pattern".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && assignment.getAssignment() instanceof J.Literal && (literal = (J.Literal)assignment.getAssignment()).getValue() instanceof String) {
                    String pattern = (String)literal.getValue();
                    return ISO_8601_PATTERNS.contains(pattern);
                }
                return false;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

