/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class UseFormatAlignedObjectMappers
extends Recipe {
    private static final MethodMatcher OBJECT_MAPPER_FACTORY = new MethodMatcher("com.fasterxml.jackson.databind.ObjectMapper <constructor>(com.fasterxml.jackson.core.JsonFactory)");
    final String displayName = "Use format alignment `ObjectMappers`";
    final String description = "Replace wrapping `ObjectMapper` calls with their format aligned implementation.";
    private static final Map<String, String> FACTORY_TO_MAPPER = new HashMap<String, String>(){
        {
            this.put("com.fasterxml.jackson.core.JsonFactory", "com.fasterxml.jackson.databind.json.JsonMapper");
            this.put("com.fasterxml.jackson.dataformat.avro.AvroFactory", "com.fasterxml.jackson.dataformat.avro.AvroMapper");
            this.put("com.fasterxml.jackson.dataformat.cbor.CBORFactory", "com.fasterxml.jackson.dataformat.cbor.CBORMapper");
            this.put("com.fasterxml.jackson.dataformat.csv.CsvFactory", "com.fasterxml.jackson.dataformat.csv.CsvMapper");
            this.put("com.fasterxml.jackson.dataformat.ion.IonFactory", "com.fasterxml.jackson.dataformat.ion.IonMapper");
            this.put("com.fasterxml.jackson.dataformat.smile.SmileFactory", "com.fasterxml.jackson.dataformat.smile.SmileMapper");
            this.put("com.fasterxml.jackson.dataformat.xml.XmlFactory", "com.fasterxml.jackson.dataformat.xml.XmlMapper");
            this.put("com.fasterxml.jackson.dataformat.yaml.YAMLFactory", "com.fasterxml.jackson.dataformat.yaml.YAMLMapper");
        }
    };

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(OBJECT_MAPPER_FACTORY), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = super.visitNewClass(newClass, (Object)ctx);
                if (!OBJECT_MAPPER_FACTORY.matches((MethodCall)nc)) {
                    return nc;
                }
                String source = String.valueOf(((Expression)nc.getArguments().get(0)).getType());
                String target = (String)FACTORY_TO_MAPPER.get(source);
                if (target != null) {
                    this.maybeRemoveImport(source);
                    this.maybeAddImport(target);
                    int lastDotIndex = target.lastIndexOf(46);
                    String packageName = target.substring(0, lastDotIndex);
                    String simpleName = target.substring(lastDotIndex + 1);
                    return (J.NewClass)JavaTemplate.builder((String)("new " + target + "()")).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{"package " + packageName + ";\npublic class " + simpleName + " extends com.fasterxml.jackson.databind.ObjectMapper {\n    public " + simpleName + "() {}\n}\n"})).build().apply(this.getCursor(), nc.getCoordinates().replace(), new Object[0]);
                }
                return nc;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

