/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.jackson;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.MethodCall;

public class UpdateSerializationInclusionConfiguration
extends Recipe {
    private static final MethodMatcher MAPPER_BUILDER_SERIALIZATION_INCLUSION_MATCHER = new MethodMatcher("com.fasterxml.jackson.databind..MapperBuilder serializationInclusion(com.fasterxml.jackson.annotation.JsonInclude.Include)");
    final String displayName = "Update configuration of serialization inclusion in ObjectMapper for Jackson 3";
    final String description = "In Jackson 3, `mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL)` is no longer supported and should be replaced by `changeDefaultPropertyInclusion()` for both `valueInclusion` and `contentInclusion`.";
    final Set<String> tags = Collections.singleton("jackson-3");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(MAPPER_BUILDER_SERIALIZATION_INCLUSION_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (MAPPER_BUILDER_SERIALIZATION_INCLUSION_MATCHER.matches((MethodCall)mi)) {
                    J.MethodInvocation result = (J.MethodInvocation)JavaTemplate.builder((String)"#{any(tools.jackson.databind.json.JsonMapper$Builder)}.changeDefaultPropertyInclusion(incl -> incl.withContentInclusion(#{any(com.fasterxml.jackson.annotation.JsonInclude.Include)}).withValueInclusion(#{any(com.fasterxml.jackson.annotation.JsonInclude.Include)}))").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"jackson-annotations-2", "jackson-core-3", "jackson-databind-3"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getSelect(), mi.getArguments().get(0), mi.getArguments().get(0)});
                    return result.getPadding().withSelect(JRightPadded.build((Object)result.getSelect()).withAfter(mi.getPadding().getSelect().getAfter()));
                }
                return mi;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

