/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hibernate;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class ReplaceLazyCollectionAnnotation
extends Recipe {
    final String displayName = "Replace `@LazyCollection` with `jakarta.persistence.FetchType`";
    final String description = "Adds the `FetchType` to jakarta annotations and deletes `@LazyCollection`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.hibernate.annotations.LazyCollection", Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                this.maybeRemoveImport("org.hibernate.annotations.LazyCollection");
                this.maybeRemoveImport("org.hibernate.annotations.LazyCollectionOption");
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration j = this.removeLazyCollectionAnnotation(method, ctx);
                return super.visitMethodDeclaration(j, (Object)ctx);
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                J.VariableDeclarations j = this.removeLazyCollectionAnnotation(multiVariable, ctx);
                return super.visitVariableDeclarations(j, (Object)ctx);
            }

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                String fetchType;
                J.Annotation ann = super.visitAnnotation(annotation, (Object)ctx);
                JavaType annType = ann.getType();
                if (!(TypeUtils.isOfClassType((JavaType)annType, (String)"jakarta.persistence.ElementCollection") || TypeUtils.isOfClassType((JavaType)annType, (String)"jakarta.persistence.OneToOne") || TypeUtils.isOfClassType((JavaType)annType, (String)"jakarta.persistence.OneToMany") || TypeUtils.isOfClassType((JavaType)annType, (String)"jakarta.persistence.ManyToOne") || TypeUtils.isOfClassType((JavaType)annType, (String)"jakarta.persistence.ManyToMany"))) {
                    return ann;
                }
                List currentArgs = ann.getArguments();
                if (currentArgs != null) {
                    if (currentArgs.stream().filter(J.Assignment.class::isInstance).map(J.Assignment.class::cast).anyMatch(arg -> "fetch".equals(((J.Identifier)arg.getVariable()).getSimpleName()))) {
                        return ann;
                    }
                }
                if ((fetchType = (String)this.getCursor().getNearestMessage("fetchType")) == null) {
                    return ann;
                }
                this.maybeAddImport("jakarta.persistence.FetchType", false);
                J.Annotation annotationWithFetch = (J.Annotation)JavaTemplate.builder((String)("fetch = " + fetchType)).imports(new String[]{"jakarta.persistence.FetchType"}).contextSensitive().build().apply(this.getCursor(), ann.getCoordinates().replaceArguments(), new Object[0]);
                JavaType fetchTypeType = JavaType.buildType((String)"jakarta.persistence.FetchType");
                J.Assignment assignment = (J.Assignment)annotationWithFetch.getArguments().get(0);
                assignment = assignment.withPrefix(currentArgs == null || currentArgs.isEmpty() ? Space.EMPTY : Space.SINGLE_SPACE).withAssignment((Expression)assignment.getAssignment().withType(fetchTypeType)).withType(fetchTypeType);
                return ann.withArguments(ListUtils.concat((List)currentArgs, (Object)assignment));
            }

            private <T extends J> T removeLazyCollectionAnnotation(T tree, ExecutionContext ctx) {
                Optional lazyAnnotation = FindAnnotations.find(tree, (String)"org.hibernate.annotations.LazyCollection").stream().findFirst();
                if (!lazyAnnotation.isPresent()) {
                    return tree;
                }
                List arguments = ((J.Annotation)lazyAnnotation.get()).getArguments();
                if (arguments == null || arguments.isEmpty()) {
                    this.getCursor().putMessage("fetchType", (Object)"FetchType.LAZY");
                } else {
                    switch (((Expression)arguments.get(0)).toString()) {
                        case "LazyCollectionOption.FALSE": {
                            this.getCursor().putMessage("fetchType", (Object)"FetchType.EAGER");
                            break;
                        }
                        case "LazyCollectionOption.TRUE": {
                            this.getCursor().putMessage("fetchType", (Object)"FetchType.LAZY");
                            break;
                        }
                        default: {
                            return tree;
                        }
                    }
                }
                return (T)((J)new RemoveAnnotationVisitor(new AnnotationMatcher("@org.hibernate.annotations.LazyCollection")).visit(tree, (Object)ctx, this.getCursor().getParentOrThrow()));
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

