/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hibernate;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;

public class RemoveInvalidHibernateGeneratedValueAnnotation
extends Recipe {
    private static final AnnotationMatcher MATCHER_GENERATED_VALUE_ANNOTATION = new AnnotationMatcher("@jakarta.persistence.GeneratedValue", Boolean.valueOf(true));
    private static final AnnotationMatcher MATCHER_ID_ANNOTATION = new AnnotationMatcher("@jakarta.persistence.Id", Boolean.valueOf(true));
    final String displayName = "Remove invalid `@GeneratedValue` annotation";
    final String description = "Removes `@GeneratedValue` annotation from fields that are not also annotated with `@Id`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("jakarta.persistence.GeneratedValue", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                if (MATCHER_GENERATED_VALUE_ANNOTATION.matches(annotation) && !((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor().getParentTreeCursor(), MATCHER_ID_ANNOTATION)) {
                    this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(this.specificAnnotationMatcher(annotation)));
                }
                return annotation;
            }

            private AnnotationMatcher specificAnnotationMatcher(final J.Annotation annotation) {
                return new AnnotationMatcher("@jakarta.persistence.GeneratedValue", true){

                    public boolean matches(J.Annotation anno) {
                        return annotation.equals((Object)anno);
                    }
                };
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

